/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.core.amazon;

import com.amazonaws.services.ec2.model.Instance;
import org.apache.airavata.xbaya.ui.widgets.TableRenderable;

public class EC2InstanceResult
implements TableRenderable {
    private static String[] columnName = new String[]{"Instance", "AMI ID", "Root Device", "Type", "Status", "Key Pair Name", "Monitoring", "Virtualization", "Placement Group"};
    private Instance instance;

    public EC2InstanceResult(Instance ins) {
        this.instance = ins;
    }

    public Instance getInstance() {
        return this.instance;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnTitle(int index) {
        return columnName[index];
    }

    @Override
    public Object getValue(int index) {
        switch (index) {
            case 0: {
                return this.instance.getInstanceId();
            }
            case 1: {
                return this.instance.getImageId();
            }
            case 2: {
                return this.instance.getRootDeviceType();
            }
            case 3: {
                return this.instance.getInstanceType();
            }
            case 4: {
                return this.instance.getState().getName();
            }
            case 5: {
                return this.instance.getKeyName();
            }
            case 6: {
                return this.instance.getMonitoring().getState();
            }
            case 7: {
                return this.instance.getVirtualizationType();
            }
            case 8: {
                return this.instance.getPlacement().getGroupName();
            }
        }
        return null;
    }
}

