/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.concurrent;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.airavata.xbaya.concurrent.PredicatedExecutable;

public class PredicatedTaskRunner {
    protected volatile ConcurrentLinkedQueue<PredicatedExecutable> jobQueue = new ConcurrentLinkedQueue();
    protected ExecutorService threadPool;
    protected volatile boolean stop = false;

    public PredicatedTaskRunner(int numberOfThreads) {
        this.threadPool = Executors.newFixedThreadPool(numberOfThreads);
        this.addIdleTask();
        this.startCheckThread();
    }

    private void addIdleTask() {
        PredicatedExecutable sleepTask = new PredicatedExecutable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ConcurrentLinkedQueue<PredicatedExecutable> concurrentLinkedQueue = PredicatedTaskRunner.this.jobQueue;
                synchronized (concurrentLinkedQueue) {
                    if (PredicatedTaskRunner.this.jobQueue.size() == 1) {
                        try {
                            PredicatedTaskRunner.this.jobQueue.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    } else if (this.allTasksAreWaiting(PredicatedTaskRunner.this.jobQueue)) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            }

            private boolean allTasksAreWaiting(ConcurrentLinkedQueue<PredicatedExecutable> jobQueue) {
                for (PredicatedExecutable predicatedExecutable : jobQueue) {
                    if (!predicatedExecutable.isReady()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isReady() {
                return true;
            }
        };
        this.jobQueue.add(sleepTask);
    }

    private void startCheckThread() {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!PredicatedTaskRunner.this.stop) {
                    try {
                        ConcurrentLinkedQueue<PredicatedExecutable> concurrentLinkedQueue = PredicatedTaskRunner.this.jobQueue;
                        synchronized (concurrentLinkedQueue) {
                            while (PredicatedTaskRunner.this.jobQueue.size() == 0 || PredicatedTaskRunner.this.allTasksAreWaiting(PredicatedTaskRunner.this.jobQueue)) {
                                PredicatedTaskRunner.this.jobQueue.wait(50L);
                            }
                        }
                        PredicatedExecutable job = (PredicatedExecutable)PredicatedTaskRunner.this.jobQueue.remove();
                        if (job.isReady()) {
                            PredicatedTaskRunner.this.threadPool.execute(job);
                            continue;
                        }
                        PredicatedTaskRunner.this.jobQueue.add(job);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private boolean allTasksAreWaiting(ConcurrentLinkedQueue<PredicatedExecutable> jobQueue) {
        for (PredicatedExecutable predicatedExecutable : jobQueue) {
            if (!predicatedExecutable.isReady()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scedule(PredicatedExecutable job) {
        ConcurrentLinkedQueue<PredicatedExecutable> concurrentLinkedQueue = this.jobQueue;
        synchronized (concurrentLinkedQueue) {
            this.jobQueue.add(job);
            this.jobQueue.notifyAll();
        }
    }

    public void shutDown() {
        this.threadPool.shutdown();
        this.stop = true;
    }
}

