/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya.component.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.workflow.model.component.ComponentRegistry;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.component.registry.JCRComponentRegistry;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.apache.airavata.xbaya.component.registry.ComponentController;
import org.apache.airavata.xbaya.ui.dialogs.WaitDialog;
import org.apache.airavata.xbaya.ui.utils.Cancelable;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentRegistryLoader
implements Cancelable,
Observer {
    private static final Logger logger = LoggerFactory.getLogger(ComponentRegistryLoader.class);
    private XBayaEngine engine;
    private Thread loadThread;
    private boolean canceled;
    private WaitDialog loadingDialog;
    private ComponentTreeNode componentTree;
    private Observable observableRegistry;
    private Map<String, ComponentTreeNode> componentTreeNodesMap;
    private static Map<String, ComponentRegistryLoader> loaders;

    private ComponentRegistryLoader(XBayaEngine engine) {
        this.setEngine(engine);
        this.loadingDialog = new WaitDialog(this, "Loading a Component List.", "Loading a Component List. Please wait for a moment.", this.getEngine().getGUI());
        this.getEngine().getConfiguration().addObserver(this);
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.loadThread.interrupt();
    }

    public void load(final ComponentRegistry registry) {
        this.canceled = false;
        this.loadThread = new Thread(){

            @Override
            public void run() {
                ComponentRegistryLoader.this.runInThread(registry);
            }
        };
        this.loadThread.start();
        if (!this.getComponentTreeNodesMap().containsKey(registry.getName())) {
            this.loadingDialog.show();
        }
    }

    private synchronized void runInThread(ComponentRegistry registry) {
        try {
            this.getEngine().getGUI().getComponentSelector().removeComponentRegistry(registry.getName());
            this.componentTree = ComponentController.getComponentTree(registry);
            if (this.canceled) {
                return;
            }
            this.getEngine().getGUI().getComponentSelector().addComponentTree(this.componentTree);
            this.loadingDialog.hide();
        }
        catch (ComponentRegistryException e) {
            if (this.canceled) {
                logger.error(e.getMessage(), (Throwable)e);
            } else {
                this.getEngine().getGUI().getErrorWindow().error("Failed to load a component list.", e);
                this.loadingDialog.hide();
            }
        }
        catch (RuntimeException e) {
            if (this.canceled) {
                logger.error(e.getMessage(), (Throwable)e);
            } else {
                this.getEngine().getGUI().getErrorWindow().error("Failed to load a component list.", e);
                this.loadingDialog.hide();
            }
        }
        catch (Error e) {
            this.getEngine().getGUI().getErrorWindow().error("Unexpected error.", e);
            this.loadingDialog.hide();
        }
    }

    @Override
    public void update(Observable observable, Object o) {
        if (observable instanceof XBayaConfiguration && o instanceof ComponentRegistry) {
            AiravataAPI registry;
            ComponentRegistry componentRegistry = (ComponentRegistry)o;
            if (this.observableRegistry != null) {
                this.observableRegistry.deleteObserver(this);
            }
            if (componentRegistry instanceof JCRComponentRegistry && (registry = ((JCRComponentRegistry)componentRegistry).getAiravataAPI()) != null && registry instanceof Observable) {
                this.observableRegistry = (Observable)registry;
                this.observableRegistry.addObserver(this);
            }
            this.load(componentRegistry);
        } else if (observable instanceof AiravataAPI) {
            this.load((ComponentRegistry)this.getEngine().getConfiguration().getJcrComponentRegistry());
        }
    }

    public XBayaEngine getEngine() {
        return this.engine;
    }

    public void setEngine(XBayaEngine engine) {
        this.engine = engine;
    }

    public Map<String, ComponentTreeNode> getComponentTreeNodesMap() {
        if (this.componentTreeNodesMap == null) {
            this.componentTreeNodesMap = new HashMap<String, ComponentTreeNode>();
        }
        return this.componentTreeNodesMap;
    }

    protected static Map<String, ComponentRegistryLoader> getLoaders() {
        if (loaders == null) {
            loaders = new HashMap<String, ComponentRegistryLoader>();
        }
        return loaders;
    }

    public static ComponentRegistryLoader getLoader(XBayaEngine engine, String id) {
        if (!ComponentRegistryLoader.getLoaders().containsKey(id)) {
            ComponentRegistryLoader.getLoaders().put(id, new ComponentRegistryLoader(engine));
        }
        return ComponentRegistryLoader.getLoaders().get(id);
    }
}

