/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya;

import java.net.URI;
import java.util.List;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.client.api.AiravataManager;
import org.apache.airavata.workflow.model.component.ComponentRegistry;
import org.apache.airavata.workflow.model.component.ComponentRegistryException;
import org.apache.airavata.workflow.model.component.amazon.AmazonComponentRegistry;
import org.apache.airavata.workflow.model.component.local.LocalComponentRegistry;
import org.apache.airavata.workflow.model.component.system.SystemComponentRegistry;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.workflow.model.exceptions.WorkflowRuntimeException;
import org.apache.airavata.ws.monitor.Monitor;
import org.apache.airavata.ws.monitor.MonitorConfiguration;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.component.registry.ComponentController;
import org.apache.airavata.xbaya.interpretor.WorkflowInterpreter;
import org.apache.airavata.xbaya.ui.XBayaGUI;
import org.apache.airavata.xbaya.ui.monitor.MonitorStarter;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentSelector;
import org.apache.airavata.xbaya.ui.widgets.component.ComponentTreeNode;
import org.apache.airavata.xbaya.workflow.WorkflowClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBayaEngine {
    private static final Logger logger = LoggerFactory.getLogger(XBayaEngine.class);
    private XBayaConfiguration configuration;
    private XBayaGUI gui;
    private WorkflowClient workflowClient;
    private Monitor monitor;
    private boolean exitOnClose = true;
    private ComponentTreeNode systemComponentTree;
    private SystemComponentRegistry componentRegistry;
    private WorkflowInterpreter workflowInterpreter;
    private AiravataAPI airavataAPI;

    public XBayaEngine(XBayaConfiguration configuration) {
        this.configuration = configuration;
        MonitorConfiguration monitorConfiguration = new MonitorConfiguration(configuration.getBrokerURL(), configuration.getTopic(), configuration.isPullMode(), configuration.getMessageBoxURL());
        this.monitor = new Monitor(monitorConfiguration);
        this.updateXBayaConfigurationServiceURLs();
        this.gui = new XBayaGUI(this);
        for (Throwable e : this.configuration.getErrors()) {
            this.getGUI().getErrorWindow().error(e.getMessage(), e);
        }
        this.initAfterGUI();
    }

    public XBayaConfiguration getConfiguration() {
        return this.configuration;
    }

    public XBayaGUI getGUI() {
        return this.gui;
    }

    public WorkflowClient getWorkflowClient() {
        return this.workflowClient;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public void dispose() throws WorkflowException {
        this.monitor.stop();
    }

    private void initAfterGUI() {
        this.initRegistry();
        this.initMonitor();
    }

    private void initRegistry() {
        ComponentSelector componentTreeViewer = this.gui.getComponentSelector();
        try {
            this.componentRegistry = new SystemComponentRegistry();
            this.systemComponentTree = ComponentController.getComponentTree((ComponentRegistry)this.componentRegistry);
            componentTreeViewer.addComponentTree(0, this.systemComponentTree);
            componentTreeViewer.addComponentTree(1, ComponentController.getComponentTree((ComponentRegistry)new AmazonComponentRegistry()));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.getGUI().getErrorWindow().error("Unexpected error.", e);
        }
        catch (ComponentRegistryException e) {
            e.printStackTrace();
            this.getGUI().getErrorWindow().error("Unexpected error.", e);
        }
        List<String> localRegistryPaths = this.configuration.getLocalRegistry();
        for (String path : localRegistryPaths) {
            try {
                LocalComponentRegistry registry = new LocalComponentRegistry(path);
                ComponentTreeNode componentTree = ComponentController.getComponentTree((ComponentRegistry)registry);
                componentTreeViewer.addComponentTree(componentTree);
            }
            catch (ComponentRegistryException e) {
                this.getGUI().getErrorWindow().error("Failed to load a component list.", e);
            }
            catch (RuntimeException e) {
                this.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
        }
    }

    private void initMonitor() {
        try {
            if (this.configuration.isStartMonitor()) {
                MonitorStarter starter = new MonitorStarter(this);
                starter.start();
            }
        }
        catch (RuntimeException e) {
            this.getGUI().getErrorWindow().error("Failed to subscribe to notification.", e);
        }
        catch (Error e) {
            this.getGUI().getErrorWindow().error("Unexpected error.", e);
        }
    }

    public void resetWorkflowInterpreter() {
        this.workflowInterpreter = null;
    }

    public WorkflowInterpreter getWorkflowInterpreter() {
        return this.workflowInterpreter;
    }

    public void registerWorkflowInterpreter(WorkflowInterpreter workflowInterpreter) {
        if (this.getWorkflowInterpreter() != null) {
            throw new WorkflowRuntimeException("Critical Error!!! Workflow interpretter already running. Cleanup first");
        }
        this.workflowInterpreter = workflowInterpreter;
    }

    public void updateXBayaConfigurationServiceURLs() {
        try {
            if (this.getConfiguration().getAiravataAPI() != null && this.getConfiguration().getAiravataAPI() != null) {
                List interpreterServiceURLList;
                URI messageBoxServiceURL;
                AiravataAPI airavataAPI = this.getConfiguration().getAiravataAPI();
                AiravataManager airavataManager = airavataAPI.getAiravataManager();
                URI eventingServiceURL = airavataManager.getEventingServiceURL();
                if (eventingServiceURL != null) {
                    this.getConfiguration().setBrokerURL(eventingServiceURL);
                    this.getMonitor().getConfiguration().setBrokerURL(eventingServiceURL);
                }
                if ((messageBoxServiceURL = airavataManager.getMessageBoxServiceURL()) != null) {
                    this.getConfiguration().setMessageBoxURL(messageBoxServiceURL);
                    this.getMonitor().getConfiguration().setMessageBoxURL(messageBoxServiceURL);
                }
                if ((interpreterServiceURLList = airavataManager.getWorkflowInterpreterServiceURLs()).size() > 0) {
                    this.getConfiguration().setWorkflowInterpreterURL((URI)interpreterServiceURLList.get(0));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AiravataAPI getAiravataAPI() {
        return this.airavataAPI;
    }

    public void setAiravataAPI(AiravataAPI airavataAPI) {
        this.airavataAPI = airavataAPI;
    }
}

