/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.airavata.client.api.AiravataAPI;
import org.apache.airavata.gfac.context.security.AmazonSecurityContext;
import org.apache.airavata.schemas.wec.ContextHeaderDocument;
import org.apache.airavata.workflow.model.component.registry.JCRComponentRegistry;
import org.apache.airavata.xbaya.XBayaConstants;
import org.apache.airavata.xbaya.core.ide.XBayaExecutionModeListener;
import org.apache.airavata.xbaya.file.XBayaPathConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xsul.lead.LeadDeploymentConfig;

public class XBayaConfiguration
extends Observable
implements Observer {
    private static final Logger logger = LoggerFactory.getLogger(XBayaConfiguration.class);
    private String title = "XBaya Dashboard";
    private String workflow = null;
    private String ogceWorkflow = null;
    private List<String> localRegistris = new ArrayList<String>();
    private URI gpelEngineURL = XBayaConstants.DEFAULT_GPEL_ENGINE_URL;
    private URI gpelTemplateID = null;
    private URI gpelInstanceID = null;
    private AiravataAPI airavataAPI = null;
    private String odeURL = "https://pagodatree.cs.indiana.edu:17443";
    private URI workflowInterpreterURL = XBayaConstants.DEFAULT_WORKFLOW_INTERPRETER_URL;
    private URI proxyURI = XBayaConstants.DEFAULT_PROXY_URI;
    private URI gfacURL = XBayaConstants.DEFAULT_GFAC_URL;
    private URI registryURL = XBayaConstants.REGISTRY_URL;
    private String regigstryUserName = "admin";
    private String registryPassphrase = "admin";
    private String defaultGateway = "default";
    private URI dscURL = XBayaConstants.DEFAULT_DSC_URL;
    private boolean startMonitor = false;
    private URI brokerURL = XBayaConstants.DEFAULT_BROKER_URL;
    private String topic = null;
    private boolean pullMode = true;
    private URI messageBoxURL = XBayaConstants.DEFAULT_MESSAGE_BOX_URL;
    private URI karmaURL = null;
    private URI karmaWorkflowInstanceID = null;
    private String myProxyServer = "myproxy.teragrid.org";
    private int myProxyPort = 7512;
    private int myProxyLifetime = 3600;
    private String myProxyUsername = null;
    private String myProxyPassphrase = null;
    private boolean loadMyProxy = false;
    private boolean loadRunJythonWorkflow = false;
    private int width;
    private int height;
    private int x = 50;
    private int y = 50;
    private List<Throwable> errors;
    private boolean closeOnExit = true;
    private boolean collectProvenance = false;
    private boolean provenanceSmartRun = false;
    private boolean runWithCrossProduct = true;
    private String trustedCertLocation = "";
    private JCRComponentRegistry jcrComponentRegistry = null;
    private XBayaExecutionMode xbayaExecutionMode = XBayaExecutionMode.IDE;
    private List<XBayaExecutionModeListener> xbayaExecutionModeChangeListners = new ArrayList<XBayaExecutionModeListener>();
    private boolean regURLSetByCMD = false;
    private AmazonSecurityContext amazonSecurityContext = null;
    private ContextHeaderDocument.ContextHeader contextHeader;

    public XBayaConfiguration() {
        this.errors = new ArrayList<Throwable>();
        String systemConfig = System.getProperty("xbaya.config");
        try {
            if (systemConfig != null) {
                this.loadConfiguration(systemConfig);
            }
        }
        catch (RuntimeException e) {
            String message = "Error while reading a configuration file, " + systemConfig;
            logger.warn(message, (Throwable)e);
        }
    }

    public void loadConfiguration(String configFilePath) {
        File configFile = new File(configFilePath);
        URI uri = configFile.toURI();
        this.loadConfiguration(uri);
    }

    private void loadConfiguration(URI uri) {
        URI msgBox;
        URI broker;
        URI dsc;
        URI gfac;
        LeadDeploymentConfig config = LeadDeploymentConfig.loadConfig(null, (URI)uri);
        URI gpel = config.getGpelUrl();
        if (gpel != null) {
            this.gpelEngineURL = config.getGpelUrl();
        }
        if ((gfac = config.getGfacUrl()) != null) {
            this.gfacURL = gfac;
        }
        if ((dsc = config.getDscUrl()) != null) {
            this.dscURL = dsc;
        }
        if ((broker = config.getBrokerUrl()) != null) {
            this.brokerURL = broker;
        }
        if ((msgBox = config.getMsgBoxUrl()) != null) {
            this.messageBoxURL = msgBox;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getWorkflow() {
        return this.workflow;
    }

    public void setWorkflow(String defaultWorkflow) {
        this.workflow = defaultWorkflow;
    }

    public void setOGCEWorkflow(String ogceWorkflow) {
        this.ogceWorkflow = ogceWorkflow;
    }

    public String getOGCEWorkflow() {
        return this.ogceWorkflow;
    }

    public void enableLocalRegistry() {
        this.addLocalRegistry(XBayaPathConstants.WSDL_DIRECTORY);
    }

    public void addLocalRegistry(String path) {
        this.localRegistris.add(path);
    }

    public List<String> getLocalRegistry() {
        return this.localRegistris;
    }

    public URI getGPELEngineURL() {
        return this.gpelEngineURL;
    }

    public void setGPELEngineURL(URI gpelEngineURL) {
        this.gpelEngineURL = gpelEngineURL;
    }

    public void setGPELTemplateID(URI templateID) {
        this.gpelTemplateID = templateID;
    }

    public URI getGPELTemplateID() {
        return this.gpelTemplateID;
    }

    public URI getGPELInstanceID() {
        return this.gpelInstanceID;
    }

    public void setGPELInstanceID(URI gpelInstanceID) {
        this.gpelInstanceID = gpelInstanceID;
    }

    public AmazonSecurityContext getAmazonSecurityContext() {
        return this.amazonSecurityContext;
    }

    public void setAmazonSecurityContext(AmazonSecurityContext amazonSecurityContext) {
        this.amazonSecurityContext = amazonSecurityContext;
    }

    public URI getGFacURL() {
        return this.gfacURL;
    }

    public void setGFacURL(URI gfacURL) {
        this.gfacURL = gfacURL;
    }

    public URI getDSCURL() {
        return this.dscURL;
    }

    public void setDSCURL(URI dscURL) {
        this.dscURL = dscURL;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public URI getMessageBoxURL() {
        return this.messageBoxURL;
    }

    public void setMessageBoxURL(URI messageBoxURL) {
        this.messageBoxURL = messageBoxURL;
    }

    public boolean isPullMode() {
        return this.pullMode;
    }

    public void setPullMode(boolean pullMode) {
        this.pullMode = pullMode;
    }

    public URI getBrokerURL() {
        return this.brokerURL;
    }

    public void setBrokerURL(URI brokerURL) {
        this.brokerURL = brokerURL;
    }

    public boolean isStartMonitor() {
        return this.startMonitor;
    }

    public void setStartMonitor(boolean startMonitor) {
        this.startMonitor = startMonitor;
    }

    public URI getKarmaURL() {
        return this.karmaURL;
    }

    public void setKarmaURL(URI kermaURI) {
        this.karmaURL = kermaURI;
    }

    public URI getKarmaWorkflowInstanceID() {
        return this.karmaWorkflowInstanceID;
    }

    public void setKarmaWorkflowInstanceID(URI karmaWorkflowInstanceID) {
        this.karmaWorkflowInstanceID = karmaWorkflowInstanceID;
    }

    public String getMyProxyServer() {
        return this.myProxyServer;
    }

    public void setMyProxyServer(String myProxyServer) {
        this.myProxyServer = myProxyServer;
    }

    public int getMyProxyPort() {
        return this.myProxyPort;
    }

    public void setMyProxyPort(int myProxyPort) {
        this.myProxyPort = myProxyPort;
    }

    public int getMyProxyLifetime() {
        return this.myProxyLifetime;
    }

    public void setMyProxyLifetime(int myProxyLifetime) {
        this.myProxyLifetime = myProxyLifetime;
    }

    public String getMyProxyUsername() {
        return this.myProxyUsername;
    }

    public void setMyProxyUsername(String myProxyUsername) {
        this.myProxyUsername = myProxyUsername;
    }

    public String getOdeURL() {
        return this.odeURL;
    }

    public void setOdeURL(String odeURL) {
        this.odeURL = odeURL;
    }

    public URI getWorkflowInterpreterURL() {
        return this.workflowInterpreterURL;
    }

    public void setWorkflowInterpreterURL(URI workflowInterpreterURL) {
        this.workflowInterpreterURL = workflowInterpreterURL;
    }

    public void setProxyURI(URI proxyURI) {
        this.proxyURI = proxyURI;
    }

    public String getMyProxyPassphrase() {
        return this.myProxyPassphrase;
    }

    public void setMyProxyPassphrase(String myProxyPassphrase) {
        this.myProxyPassphrase = myProxyPassphrase;
    }

    public boolean isLoadMyProxy() {
        return this.loadMyProxy;
    }

    public void setLoadMyProxy(boolean loadMyProxy) {
        this.loadMyProxy = loadMyProxy;
    }

    public boolean isLoadRunJythonWorkflow() {
        return this.loadRunJythonWorkflow;
    }

    public void setLoadRunJythonWorkflow(boolean loadRunJythonWorkflow) {
        this.loadRunJythonWorkflow = loadRunJythonWorkflow;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void addError(Throwable e) {
        this.errors.add(e);
    }

    public Iterable<Throwable> getErrors() {
        return this.errors;
    }

    public String getODEURL() {
        return this.odeURL;
    }

    public URI getProxyURI() {
        return this.proxyURI;
    }

    public void setCloseOnExit(boolean b) {
        this.closeOnExit = b;
    }

    public boolean isCloseOnExit() {
        return this.closeOnExit;
    }

    public AiravataAPI getAiravataAPI() {
        return this.airavataAPI;
    }

    public void setAiravataAPI(AiravataAPI airavataAPI) {
        if (this.airavataAPI != null && this.airavataAPI instanceof Observable) {
            ((Observable)this.airavataAPI).deleteObserver(this);
        }
        this.airavataAPI = airavataAPI;
        if (airavataAPI != null && airavataAPI instanceof Observable) {
            ((Observable)airavataAPI).addObserver(this);
        }
        if (this.getJcrComponentRegistry() == null) {
            this.setJcrComponentRegistry(new JCRComponentRegistry(airavataAPI));
        } else {
            this.getJcrComponentRegistry().setAiravataAPI(airavataAPI);
        }
        this.triggerObservers(this.getJcrComponentRegistry());
    }

    public URI getRegistryURL() {
        return this.registryURL;
    }

    public void setRegistryURL(URI registryURL) {
        this.registryURL = registryURL;
    }

    public void setRegigstryUserName(String regigstryUserName) {
        this.regigstryUserName = regigstryUserName;
    }

    public void setRegistryPassphrase(String registryPassphrase) {
        this.registryPassphrase = registryPassphrase;
    }

    public String getRegistryUserName() {
        return this.regigstryUserName;
    }

    public String getRegistryPassphrase() {
        return this.registryPassphrase;
    }

    protected void triggerObservers(Object o) {
        this.setChanged();
        this.notifyObservers(o);
    }

    @Override
    public void update(Observable observable, Object o) {
        this.triggerObservers(observable);
    }

    public boolean isCollectProvenance() {
        return this.collectProvenance;
    }

    public boolean isProvenanceSmartRun() {
        return this.provenanceSmartRun;
    }

    public void setCollectProvenance(boolean collectProvenance) {
        this.collectProvenance = collectProvenance;
    }

    public void setProvenanceSmartRun(boolean provenanceSmartRun) {
        this.provenanceSmartRun = provenanceSmartRun;
    }

    public void setRunWithCrossProduct(boolean runWithCrossProduct) {
        this.runWithCrossProduct = runWithCrossProduct;
    }

    public boolean isRunWithCrossProduct() {
        return this.runWithCrossProduct;
    }

    public String getTrustedCertLocation() {
        return this.trustedCertLocation;
    }

    public void setTrustedCertLocation(String trustedCertLocation) {
        this.trustedCertLocation = trustedCertLocation;
    }

    public XBayaExecutionMode getXbayaExecutionMode() {
        return this.xbayaExecutionMode;
    }

    public void setXbayaExecutionMode(XBayaExecutionMode xbayaExecutionMode) {
        boolean modeChanged = this.xbayaExecutionMode != xbayaExecutionMode;
        this.xbayaExecutionMode = xbayaExecutionMode;
        if (modeChanged) {
            for (XBayaExecutionModeListener listner : this.xbayaExecutionModeChangeListners) {
                try {
                    listner.executionModeChanged(this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void registerExecutionModeChangeListener(XBayaExecutionModeListener listner) {
        this.xbayaExecutionModeChangeListners.add(listner);
    }

    public void unregisterExecutionModeChangeListener(XBayaExecutionModeListener listner) {
        if (this.xbayaExecutionModeChangeListners.contains(listner)) {
            this.xbayaExecutionModeChangeListners.remove(listner);
        }
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public String getDefaultGateway() {
        return this.defaultGateway;
    }

    public void setDefaultGateway(String defaultGateway) {
        this.defaultGateway = defaultGateway;
    }

    public JCRComponentRegistry getJcrComponentRegistry() {
        return this.jcrComponentRegistry;
    }

    public void setJcrComponentRegistry(JCRComponentRegistry jcrComponentRegistry) {
        this.jcrComponentRegistry = jcrComponentRegistry;
    }

    public boolean isRegURLSetByCMD() {
        return this.regURLSetByCMD;
    }

    public void setRegURLSetByCMD(boolean regURLSetByCMD) {
        this.regURLSetByCMD = regURLSetByCMD;
    }

    public ContextHeaderDocument.ContextHeader getContextHeader() {
        return this.contextHeader;
    }

    public void setContextHeader(ContextHeaderDocument.ContextHeader contextHeader) {
        this.contextHeader = contextHeader;
    }

    public static enum XBayaExecutionMode {
        IDE,
        MONITOR;

    }
}

