/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.xbaya;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.airavata.workflow.model.exceptions.WorkflowException;
import org.apache.airavata.xbaya.XBayaConfiguration;
import org.apache.airavata.xbaya.XBayaEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XBaya {
    private static final Logger logger = LoggerFactory.getLogger(XBaya.class);
    private XBayaConfiguration config;
    private XBayaEngine engine;
    public static int preservice = 0;

    public XBaya(String[] args) {
        this.parseArguments(args);
        try {
            this.engine = new XBayaEngine(this.config);
        }
        catch (RuntimeException e) {
            logger.error(e.getMessage(), (Throwable)e);
            try {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (Throwable t) {
                e.printStackTrace();
            }
        }
        catch (Error e) {
            logger.error(e.getMessage(), (Throwable)e);
            try {
                this.engine.getGUI().getErrorWindow().error("Unexpected error.", e);
            }
            catch (Throwable t) {
                System.out.println(e);
            }
        }
    }

    public XBayaEngine getEngine() {
        return this.engine;
    }

    private void printUsage() {
        System.err.println("Usage: java " + XBaya.class.getName() + " [-help]" + "[-config file]" + " [-title title]" + " [-workflow workflow]" + " [-enableLocalRegistry]" + " [-localRegistry dir]" + " [-gpelEngineURL url]" + " [-templateID templateID]" + " [-instanceID instanceID]" + " [-gfacURL url]" + " [-dscURL url" + " [-startMonitor {true,false}]" + " [-brokerURL url]" + " [-topic topic]" + " [-pullMode {true,false}]" + " [-myProxyServer host]" + " [-karmaURL url]" + " [-karmaWorkflowInstanceID]" + " [-myProxyPort port]" + " [-myProxyUsername username]" + " [-myProxyLifetime sec]" + " [-loadMyProxy {true,false}]" + " [-messageBoxURL url]" + " [-width width]" + " [-height height]" + " [-exitOnClose false/true]" + "[-enableProvenance false/true]" + "[-enableProvenanceSmartRun false/true]" + "[-runWithCrossProduct true/false]" + "[-mode ide/monitor]" + "[--x x-coordinates of left top corner] " + "+ [--y y-coordinate of left top corner]");
    }

    private void parseArguments(String[] args) {
        try {
            this.config = new XBayaConfiguration();
            for (int index = 0; index < args.length; ++index) {
                String exit;
                String url;
                String message;
                String arg = args[index];
                String possibleValue = "";
                if (index + 1 < args.length) {
                    possibleValue = args[index + 1];
                }
                logger.debug("arg: " + arg + " " + possibleValue);
                if ("-help".equalsIgnoreCase(arg)) {
                    this.printUsage();
                    System.exit(0);
                } else if ("-config".equalsIgnoreCase(arg)) {
                    String configPath = args[++index];
                    try {
                        this.config.loadConfiguration(configPath);
                    }
                    catch (RuntimeException e) {
                        message = "Error while reading config file, " + configPath;
                        logger.warn(message, (Throwable)e);
                        this.config.addError(new WorkflowException(message, (Throwable)e));
                    }
                } else if ("-title".equalsIgnoreCase(arg)) {
                    this.config.setTitle(args[++index]);
                } else if ("-workflow".equalsIgnoreCase(arg)) {
                    this.config.setWorkflow(args[++index]);
                } else if ("-gfacURL".equalsIgnoreCase(arg)) {
                    url = args[++index];
                    try {
                        this.config.setGFacURL(this.parseURL(url));
                    }
                    catch (URISyntaxException e) {
                        message = "The GFac URL is in wrong format: " + url;
                        logger.warn(message, (Throwable)e);
                        this.config.addError(new WorkflowException(message, (Throwable)e));
                    }
                } else if ("-dscURL".equalsIgnoreCase(arg)) {
                    url = args[++index];
                    try {
                        this.config.setDSCURL(this.parseURL(url));
                    }
                    catch (URISyntaxException e) {
                        message = "The DSC URL is in wrong format: " + url;
                        logger.warn(message, (Throwable)e);
                        this.config.addError(new WorkflowException(message, (Throwable)e));
                    }
                } else if ("-startMonitor".equalsIgnoreCase(arg)) {
                    this.config.setStartMonitor(true);
                } else if ("-brokerURL".equalsIgnoreCase(arg)) {
                    String brokerURL = args[++index];
                    try {
                        this.config.setBrokerURL(this.parseURL(brokerURL));
                    }
                    catch (URISyntaxException e) {
                        message = "The broker URL is in wrong format: " + brokerURL;
                        logger.warn(message, (Throwable)e);
                        this.config.addError(new WorkflowException(message, (Throwable)e));
                    }
                } else if ("-odeEngine".equalsIgnoreCase(arg)) {
                    this.config.setOdeURL(args[++index]);
                } else if ("-templateID".equalsIgnoreCase(arg)) {
                    this.config.setWorkflow(args[++index]);
                } else if ("-topic".equalsIgnoreCase(arg)) {
                    this.config.setTopic(args[++index]);
                } else if ("-pullMode".equalsIgnoreCase(arg)) {
                    if (index < args.length - 1) {
                        String nextArg = args[index + 1];
                        if (nextArg.startsWith("-")) {
                            this.config.setPullMode(true);
                        } else if ("true".equalsIgnoreCase(nextArg)) {
                            ++index;
                            this.config.setPullMode(true);
                        } else if ("false".equalsIgnoreCase(nextArg)) {
                            ++index;
                            this.config.setPullMode(false);
                        } else {
                            String message2 = "-pullMode has to be either true or false, not " + nextArg;
                            logger.warn(message2);
                            this.config.addError(new WorkflowException(message2));
                        }
                    } else {
                        this.config.setPullMode(true);
                    }
                } else if ("-messageBoxURL".equalsIgnoreCase(arg) || "-msgBoxURL".equalsIgnoreCase(arg)) {
                    String messageBoxURL = args[++index];
                    try {
                        this.config.setMessageBoxURL(this.parseURL(messageBoxURL));
                    }
                    catch (URISyntaxException e) {
                        message = "The message box URL is in wrong format: " + messageBoxURL;
                        logger.warn(message, (Throwable)e);
                        this.config.addError(new WorkflowException(message, (Throwable)e));
                    }
                } else if ("-registryURL".equalsIgnoreCase(arg)) {
                    String registryURL = args[++index];
                    try {
                        this.config.setRegistryURL(this.parseURL(registryURL));
                        this.config.setRegURLSetByCMD(true);
                    }
                    catch (URISyntaxException e) {
                        message = "The message box URL is in wrong format: " + registryURL;
                        logger.warn(message, (Throwable)e);
                        this.config.addError(new WorkflowException(message, (Throwable)e));
                    }
                } else if ("-registryUserName".equalsIgnoreCase(arg)) {
                    this.config.setRegigstryUserName(args[++index]);
                } else if ("-registryPassphrase".equalsIgnoreCase(arg)) {
                    this.config.setRegistryPassphrase(args[++index]);
                } else if ("-width".equalsIgnoreCase(arg)) {
                    String width = args[++index];
                    try {
                        this.config.setWidth(Integer.parseInt(width));
                    }
                    catch (NumberFormatException e) {
                        message = "The width must be an integer: " + width;
                        logger.warn(message, (Throwable)e);
                        this.config.addError(new WorkflowException(message, (Throwable)e));
                    }
                } else if ("-height".equalsIgnoreCase(arg)) {
                    String height = args[++index];
                    try {
                        this.config.setHeight(Integer.parseInt(height));
                    }
                    catch (NumberFormatException e) {
                        message = "The height must be an integer: " + height;
                        logger.warn(message, (Throwable)e);
                        this.config.addError(new WorkflowException(message, (Throwable)e));
                    }
                } else if ("-exitOnClose".equalsIgnoreCase(arg)) {
                    if ("false".equalsIgnoreCase(exit = args[++index])) {
                        this.config.setCloseOnExit(false);
                    }
                } else if ("-enableProvenance".equalsIgnoreCase(arg)) {
                    if ("true".equalsIgnoreCase(exit = args[++index])) {
                        this.config.setCollectProvenance(true);
                    }
                } else if ("-enableProvenanceSmartRun".equalsIgnoreCase(arg)) {
                    if ("true".equalsIgnoreCase(exit = args[++index])) {
                        this.config.setProvenanceSmartRun(true);
                    }
                } else if ("-runWithCrossProduct".equalsIgnoreCase(arg)) {
                    if ("false".equalsIgnoreCase(exit = args[++index])) {
                        this.config.setRunWithCrossProduct(false);
                    }
                } else if ("-mode".equalsIgnoreCase(arg)) {
                    String modeValue = args[++index].toUpperCase();
                    this.config.setXbayaExecutionMode(XBayaConfiguration.XBayaExecutionMode.valueOf(modeValue));
                } else if ("-x".equalsIgnoreCase(arg)) {
                    this.config.setX(Integer.parseInt(args[++index]));
                } else if ("-y".equalsIgnoreCase(arg)) {
                    this.config.setY(Integer.parseInt(args[++index]));
                } else {
                    String message3 = "Unknown option: " + arg;
                    logger.error(message3);
                    this.config.addError(new WorkflowException(message3));
                }
                this.config.setAiravataAPI(this.config.getAiravataAPI());
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String message = "Argument is missing after " + args[args.length - 1];
            logger.error(message, (Throwable)e);
            this.config.addError(new WorkflowException(message));
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
            String message = "Unknown error while parsing the arguments";
            this.config.addError(new WorkflowException(message, e));
        }
    }

    private URI parseURL(String urlString) throws URISyntaxException {
        if (urlString.trim().length() == 0) {
            return null;
        }
        if ("null".equalsIgnoreCase(urlString)) {
            return null;
        }
        return new URI(urlString).parseServerAuthority();
    }

    public static void main(String[] args) {
        new XBaya(args);
    }
}

