/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.server;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataZKUtils;
import org.apache.airavata.common.utils.ApplicationSettings;
import org.apache.airavata.common.utils.IServer;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.StringUtil;
import org.apache.commons.cli.ParseException;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.management.VMManagement;

public class ServerMain {
    private static List<IServer> servers;
    private static final String SERVERS_KEY = "servers";
    private static final Logger logger;
    private static boolean serversLoaded;
    private static final String stopFileNamePrefix = "airavata-server-stop";
    private static int serverPID;
    private static final String serverStartedFileNamePrefix = "server-start";
    private static boolean systemShutDown;
    private static String STOP_COMMAND_STR;
    private static ServerCnxnFactory cnxnFactory;
    private static final int SERVER_STATUS_CHANGE_WAIT_INTERVAL = 100;

    private static void loadServers(String serverNames) {
        try {
            if (serverNames != null) {
                String[] serversList;
                for (String serverString : serversList = serverNames.split(",")) {
                    serverString = serverString.trim();
                    String serverClassName = ServerSettings.getSetting((String)serverString);
                    try {
                        Class<?> classInstance = ServerMain.class.getClassLoader().loadClass(serverClassName);
                        servers.add((IServer)classInstance.newInstance());
                    }
                    catch (ClassNotFoundException e) {
                        logger.error("Error while locating server implementation \"" + serverString + "\"!!!", (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        logger.error("Error while initiating server instance \"" + serverString + "\"!!!", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        logger.error("Error while initiating server instance \"" + serverString + "\"!!!", (Throwable)e);
                    }
                    catch (ClassCastException e) {
                        logger.error("Invalid server \"" + serverString + "\"!!!", (Throwable)e);
                    }
                }
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error("Error while retrieving server list!!!", (Throwable)e);
        }
        serversLoaded = true;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ServerMain.setSystemShutDown(true);
                ServerMain.stopAllServers();
            }
        });
    }

    public static void main(String[] args) throws ParseException, IOException {
        StringUtil.CommandLineParameters commandLineParameters = StringUtil.getCommandLineParser((String[])args);
        if (commandLineParameters.getArguments().contains(STOP_COMMAND_STR)) {
            ServerMain.performServerStopRequest(commandLineParameters);
        } else {
            AiravataZKUtils.startEmbeddedZK((ServerCnxnFactory)cnxnFactory);
            ServerMain.performServerStart(args);
        }
    }

    private static void performServerStart(String[] args) {
        ServerMain.setServerStarted();
        logger.info("Airavata server instance starting...");
        for (String string : args) {
            logger.info("Server Arguments: " + string);
        }
        ServerSettings.mergeSettingsCommandLineArgs((String[])args);
        try {
            String serverNames = ApplicationSettings.getSetting((String)SERVERS_KEY);
            ServerMain.startAllServers(serverNames);
        }
        catch (ApplicationSettingsException e1) {
            logger.error("Error finding servers property");
        }
        while (!ServerMain.hasStopRequested()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                ServerMain.stopAllServers();
            }
        }
        if (ServerMain.hasStopRequested()) {
            ApplicationSettings.ShutdownStrategy shutdownStrategy;
            ServerSettings.setStopAllThreads((boolean)true);
            ServerMain.stopAllServers();
            try {
                shutdownStrategy = ServerSettings.getShutdownStrategy();
            }
            catch (Exception e) {
                String strategies = "";
                for (ApplicationSettings.ShutdownStrategy s : ApplicationSettings.ShutdownStrategy.values()) {
                    strategies = strategies + "/" + s.toString();
                }
                logger.warn(e.getMessage());
                logger.warn("Valid shutdown options are : " + strategies.substring(1));
                shutdownStrategy = ApplicationSettings.ShutdownStrategy.SELF_TERMINATE;
            }
            if (shutdownStrategy == ApplicationSettings.ShutdownStrategy.SELF_TERMINATE) {
                System.exit(0);
            }
        }
    }

    private static void performServerStopRequest(StringUtil.CommandLineParameters commandLineParameters) throws IOException {
        String serverIndexOption = "serverIndex";
        if (commandLineParameters.getParameters().containsKey(serverIndexOption)) {
            serverPID = Integer.parseInt((String)commandLineParameters.getParameters().get(serverIndexOption));
        }
        if (ServerMain.isServerRunning()) {
            logger.info("Requesting airavata server" + (serverPID == -1 ? "(s)" : " instance " + serverPID) + " to stop...");
            ServerMain.requestStop();
            while (ServerMain.isServerRunning()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            logger.info("Server" + (serverPID == -1 ? "(s)" : " instance " + serverPID) + " stopped!!!");
        } else {
            logger.error("Server" + (serverPID == -1 ? "" : " instance " + serverPID) + " is not running!!!");
        }
        if (ServerSettings.isEmbeddedZK()) {
            cnxnFactory.shutdown();
        }
    }

    private static void requestStop() throws IOException {
        File file = new File(ServerMain.getServerStopFileName());
        file.createNewFile();
        new RandomAccessFile(file, "rw").getChannel().lock();
        file.deleteOnExit();
    }

    private static boolean hasStopRequested() {
        return ServerMain.isSystemShutDown() || new File(ServerMain.getServerStopFileName()).exists() || new File(stopFileNamePrefix).exists();
    }

    private static String getServerStopFileName() {
        return stopFileNamePrefix;
    }

    private static void deleteOldStopRequests() {
        File[] files;
        for (File file : files = new File(".").listFiles()) {
            if (!file.getName().contains(stopFileNamePrefix)) continue;
            file.delete();
        }
    }

    private static boolean isServerRunning() {
        if (serverPID == -1) {
            String[] files;
            for (String file : files = new File(".").list()) {
                if (!file.contains(serverStartedFileNamePrefix)) continue;
                return true;
            }
            return false;
        }
        return new File(ServerMain.getServerStartedFileName()).exists();
    }

    private static void setServerStarted() {
        try {
            serverPID = ServerMain.getPID();
            ServerMain.deleteOldStopRequests();
            File serverStartedFile = null;
            serverStartedFile = new File(ServerMain.getServerStartedFileName());
            serverStartedFile.createNewFile();
            serverStartedFile.deleteOnExit();
            new RandomAccessFile(serverStartedFile, "rw").getChannel().lock();
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private static String getServerStartedFileName() {
        return new File(new File(System.getenv("AIRAVATA_HOME"), "bin"), "server-start_" + Integer.toString(serverPID)).toString();
    }

    public static void stopAllServers() {
        for (int i = servers.size() - 1; i >= 0; --i) {
            try {
                servers.get(i).stop();
                ServerMain.waitForServerToStop(servers.get(i), null);
                continue;
            }
            catch (Exception e) {
                logger.error("Server Stop Error:", (Throwable)e);
            }
        }
    }

    public static void startAllServers(String serversNames) {
        if (!serversLoaded) {
            ServerMain.loadServers(serversNames);
        }
        for (IServer server : servers) {
            try {
                server.configure();
                server.start();
                ServerMain.waitForServerToStart(server, null);
            }
            catch (Exception e) {
                logger.error("Server Start Error:", (Throwable)e);
            }
        }
    }

    private static void waitForServerToStart(IServer server, Integer maxWait) throws Exception {
        for (int count = 0; server.getStatus() == IServer.ServerStatus.STARTING && (maxWait == null || count < maxWait); count += 100) {
            Thread.sleep(100L);
        }
        if (server.getStatus() != IServer.ServerStatus.STARTED) {
            logger.error("The " + server.getName() + " did not start!!!");
        }
    }

    private static void waitForServerToStop(IServer server, Integer maxWait) throws Exception {
        int count = 0;
        if (server.getStatus() == IServer.ServerStatus.STOPING) {
            logger.info("Waiting for " + server.getName() + " to stop...");
        }
        while (server.getStatus() == IServer.ServerStatus.STOPING && (maxWait == null || count < maxWait)) {
            Thread.sleep(100L);
            count += 100;
        }
        if (server.getStatus() != IServer.ServerStatus.STOPPED) {
            logger.error("Error stopping the " + server.getName() + "!!!");
        }
    }

    private static boolean isSystemShutDown() {
        return systemShutDown;
    }

    private static void setSystemShutDown(boolean systemShutDown) {
        ServerMain.systemShutDown = systemShutDown;
    }

    private static int getPID() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            Field jvm = runtime.getClass().getDeclaredField("jvm");
            jvm.setAccessible(true);
            VMManagement mgmt = (VMManagement)jvm.get(runtime);
            Method pid_method = mgmt.getClass().getDeclaredMethod("getProcessId", new Class[0]);
            pid_method.setAccessible(true);
            int pid = (Integer)pid_method.invoke((Object)mgmt, new Object[0]);
            return pid;
        }
        catch (Exception e) {
            return -1;
        }
    }

    static {
        logger = LoggerFactory.getLogger(ServerMain.class);
        serversLoaded = false;
        serverPID = -1;
        systemShutDown = false;
        STOP_COMMAND_STR = "stop";
        servers = new ArrayList<IServer>();
    }
}

