/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core.impl;

import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.messaging.core.impl.RabbitMQProducer;
import org.apache.airavata.model.messaging.event.Message;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQProcessLaunchPublisher
implements Publisher {
    private static final Logger log = LoggerFactory.getLogger(RabbitMQProcessLaunchPublisher.class);
    private String launchTask;
    private RabbitMQProducer rabbitMQProducer;

    public RabbitMQProcessLaunchPublisher() throws Exception {
        String brokerUrl;
        try {
            brokerUrl = ServerSettings.getSetting((String)"rabbitmq.broker.url");
            this.launchTask = ServerSettings.getLaunchQueueName();
        }
        catch (ApplicationSettingsException e) {
            String message = "Failed to get read the required properties from airavata to initialize rabbitmq";
            log.error(message, (Throwable)e);
            throw new AiravataException(message, (Throwable)e);
        }
        this.rabbitMQProducer = new RabbitMQProducer(brokerUrl, null, null);
        this.rabbitMQProducer.open();
    }

    @Override
    public void publish(MessageContext msgCtx) throws AiravataException {
        try {
            log.info("Publishing to launch queue ...");
            byte[] body = ThriftUtils.serializeThriftObject((TBase)msgCtx.getEvent());
            Message message = new Message();
            message.setEvent(body);
            message.setMessageId(msgCtx.getMessageId());
            message.setMessageType(msgCtx.getType());
            message.setUpdatedTime(msgCtx.getUpdatedTime().getTime());
            String routingKey = this.launchTask;
            byte[] messageBody = ThriftUtils.serializeThriftObject((TBase)message);
            this.rabbitMQProducer.sendToWorkerQueue(messageBody, routingKey);
            log.info("Successfully published to launch queue ...");
        }
        catch (TException e) {
            String msg = "Error while deserializing the object";
            log.error(msg, (Throwable)e);
            throw new AiravataException(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Error while sending to rabbitmq";
            log.error(msg, (Throwable)e);
            throw new AiravataException(msg, (Throwable)e);
        }
    }
}

