/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.QueueingConsumer;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.messaging.core.impl.RabbitMQStatusConsumer;
import org.apache.airavata.model.messaging.event.Message;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.airavata.model.messaging.event.ProcessSubmitEvent;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQProcessLaunchConsumer {
    private static final Logger logger = LoggerFactory.getLogger(RabbitMQProcessLaunchConsumer.class);
    private static Logger log = LoggerFactory.getLogger(RabbitMQStatusConsumer.class);
    private String taskLaunchExchangeName;
    private String url;
    private Connection connection;
    private Channel channel;
    private Map<String, QueueDetails> queueDetailsMap = new HashMap<String, QueueDetails>();
    private boolean durableQueue;
    private MessageHandler messageHandler;
    private int prefetchCount;

    public RabbitMQProcessLaunchConsumer() throws AiravataException {
        try {
            this.url = ServerSettings.getSetting((String)"rabbitmq.broker.url");
            this.durableQueue = Boolean.parseBoolean(ServerSettings.getSetting((String)"durable.queue"));
            this.taskLaunchExchangeName = ServerSettings.getSetting((String)"rabbitmq.task.launch.exchange.name");
            this.prefetchCount = Integer.valueOf(ServerSettings.getSetting((String)"prefetch.count", (String)String.valueOf(64)));
            this.createConnection();
        }
        catch (ApplicationSettingsException e) {
            String message = "Failed to get read the required properties from airavata to initialize rabbitmq";
            log.error(message, (Throwable)e);
            throw new AiravataException(message, (Throwable)e);
        }
    }

    public RabbitMQProcessLaunchConsumer(String brokerUrl, String exchangeName) throws AiravataException {
        this.taskLaunchExchangeName = exchangeName;
        this.url = brokerUrl;
        this.createConnection();
    }

    private void createConnection() throws AiravataException {
        try {
            ConnectionFactory connectionFactory = new ConnectionFactory();
            connectionFactory.setUri(this.url);
            connectionFactory.setAutomaticRecoveryEnabled(true);
            this.connection = connectionFactory.newConnection();
            this.connection.addShutdownListener(new ShutdownListener(){

                public void shutdownCompleted(ShutdownSignalException cause) {
                }
            });
            log.info("connected to rabbitmq: " + this.connection + " for " + this.taskLaunchExchangeName);
            this.channel = this.connection.createChannel();
            this.channel.basicQos(this.prefetchCount);
        }
        catch (Exception e) {
            String msg = "could not open channel for exchange " + this.taskLaunchExchangeName;
            log.error(msg);
            throw new AiravataException(msg, (Throwable)e);
        }
    }

    public void reconnect() throws AiravataException {
        if (this.messageHandler != null) {
            try {
                this.listen(this.messageHandler);
            }
            catch (AiravataException e) {
                String msg = "could not open channel for exchange " + this.taskLaunchExchangeName;
                log.error(msg);
                throw new AiravataException(msg, (Throwable)e);
            }
        }
    }

    public String listen(final MessageHandler handler) throws AiravataException {
        try {
            this.messageHandler = handler;
            Map<String, Object> props = handler.getProperties();
            Object routing = props.get("routingKey");
            if (routing == null) {
                throw new IllegalArgumentException("The routing key must be present");
            }
            ArrayList<String> keys = new ArrayList<String>();
            if (routing instanceof List) {
                for (Object o : (List)routing) {
                    keys.add(o.toString());
                }
            } else if (routing instanceof String) {
                keys.add((String)routing);
            }
            String queueName = (String)props.get("queue");
            String consumerTag = (String)props.get("consumerTag");
            if (queueName == null) {
                if (!this.channel.isOpen()) {
                    this.channel = this.connection.createChannel();
                    this.channel.basicQos(this.prefetchCount);
                }
                queueName = this.channel.queueDeclare().getQueue();
            } else {
                this.channel.queueDeclare(queueName, this.durableQueue, false, false, null);
            }
            final String id = this.getId(keys, queueName);
            if (this.queueDetailsMap.containsKey(id)) {
                throw new IllegalStateException("This subscriber is already defined for this Consumer, cannot define the same subscriber twice");
            }
            if (consumerTag == null) {
                consumerTag = "default";
            }
            this.channel.basicConsume(queueName, false, consumerTag, (Consumer)new QueueingConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
                    Message message = new Message();
                    try {
                        ThriftUtils.createThriftFromBytes((byte[])body, (TBase)message);
                        ProcessSubmitEvent event = null;
                        String gatewayId = null;
                        long deliveryTag = envelope.getDeliveryTag();
                        if (message.getMessageType().equals((Object)MessageType.LAUNCHPROCESS)) {
                            ProcessSubmitEvent processSubmitEvent = new ProcessSubmitEvent();
                            ThriftUtils.createThriftFromBytes((byte[])message.getEvent(), (TBase)processSubmitEvent);
                            log.debug(" Message Received with message id '" + message.getMessageId() + "' and with message type '" + message.getMessageType() + "'  for experimentId:" + " " + processSubmitEvent.getProcessId());
                            event = processSubmitEvent;
                            gatewayId = processSubmitEvent.getGatewayId();
                            MessageContext messageContext = new MessageContext((TBase)event, message.getMessageType(), message.getMessageId(), gatewayId, deliveryTag);
                            messageContext.setUpdatedTime(AiravataUtils.getTime((long)message.getUpdatedTime()));
                            messageContext.setIsRedeliver(envelope.isRedeliver());
                            handler.onMessage(messageContext);
                        } else {
                            log.error("{} message type is not handle in ProcessLaunch Consumer. Sending ack for delivery tag {} ", (Object)message.getMessageType().name(), (Object)deliveryTag);
                            RabbitMQProcessLaunchConsumer.this.sendAck(deliveryTag);
                        }
                    }
                    catch (TException e) {
                        String msg = "Failed to de-serialize the thrift message, from routing keys and queueName " + id;
                        log.warn(msg, (Throwable)e);
                    }
                }

                public void handleCancel(String consumerTag) throws IOException {
                    super.handleCancel(consumerTag);
                    log.info("Consumer cancelled : " + consumerTag);
                }
            });
            this.queueDetailsMap.put(id, new QueueDetails(queueName, keys));
            return id;
        }
        catch (Exception e) {
            String msg = "could not open channel for exchange " + this.taskLaunchExchangeName;
            log.error(msg);
            throw new AiravataException(msg, (Throwable)e);
        }
    }

    public void stopListen(String id) throws AiravataException {
        QueueDetails details = this.queueDetailsMap.get(id);
        if (details != null) {
            try {
                for (String key : details.getRoutingKeys()) {
                    this.channel.queueUnbind(details.getQueueName(), this.taskLaunchExchangeName, key);
                }
            }
            catch (IOException e) {
                String msg = "could not un-bind queue: " + details.getQueueName() + " for exchange " + this.taskLaunchExchangeName;
                log.debug(msg);
            }
        }
    }

    private String getId(List<String> routingKeys, String queueName) {
        String id = "";
        for (String key : routingKeys) {
            id = id + "_" + key;
        }
        return id + "_" + queueName;
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean isOpen() {
        if (this.connection != null) {
            return this.connection.isOpen();
        }
        return false;
    }

    public void sendAck(long deliveryTag) {
        try {
            if (this.channel.isOpen()) {
                this.channel.basicAck(deliveryTag, false);
            } else {
                this.channel = this.connection.createChannel();
                this.channel.basicQos(this.prefetchCount);
                this.channel.basicAck(deliveryTag, false);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private class QueueDetails {
        String queueName;
        List<String> routingKeys;

        private QueueDetails(String queueName, List<String> routingKeys) {
            this.queueName = queueName;
            this.routingKeys = routingKeys;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public List<String> getRoutingKeys() {
            return this.routingKeys;
        }
    }
}

