/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.MessageHandler;
import org.apache.airavata.messaging.core.impl.RabbitMQStatusConsumer;
import org.apache.airavata.model.messaging.event.ExperimentStatusChangeEvent;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClient {
    public static final String RABBITMQ_BROKER_URL = "rabbitmq.broker.url";
    public static final String RABBITMQ_EXCHANGE_NAME = "rabbitmq.exchange.name";
    private static final Logger logger = LoggerFactory.getLogger(TestClient.class);
    private static final String experimentId = "*";

    public static void main(String[] args) {
        try {
            String brokerUrl = ServerSettings.getSetting((String)RABBITMQ_BROKER_URL);
            String exchangeName = ServerSettings.getSetting((String)RABBITMQ_EXCHANGE_NAME);
            RabbitMQStatusConsumer consumer = new RabbitMQStatusConsumer(brokerUrl, exchangeName);
            consumer.listen(new MessageHandler(){

                @Override
                public Map<String, Object> getProperties() {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    ArrayList<String> routingKeys = new ArrayList<String>();
                    routingKeys.add(TestClient.experimentId);
                    routingKeys.add("*.*");
                    props.put("routingKey", routingKeys);
                    return props;
                }

                @Override
                public void onMessage(MessageContext message) {
                    if (message.getType().equals((Object)MessageType.EXPERIMENT)) {
                        try {
                            ExperimentStatusChangeEvent event = new ExperimentStatusChangeEvent();
                            TBase messageEvent = message.getEvent();
                            byte[] bytes = ThriftUtils.serializeThriftObject((TBase)messageEvent);
                            ThriftUtils.createThriftFromBytes((byte[])bytes, (TBase)event);
                            System.out.println(" Message Received with message id '" + message.getMessageId() + "' and with message type '" + message.getType() + "' and with state : '" + event.getState().toString());
                        }
                        catch (TException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (ApplicationSettingsException e) {
            logger.error("Error reading airavata server properties", (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

