/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core.impl;

import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.common.utils.ThriftUtils;
import org.apache.airavata.messaging.core.MessageContext;
import org.apache.airavata.messaging.core.Publisher;
import org.apache.airavata.messaging.core.impl.RabbitMQProducer;
import org.apache.airavata.model.messaging.event.ExperimentStatusChangeEvent;
import org.apache.airavata.model.messaging.event.JobIdentifier;
import org.apache.airavata.model.messaging.event.JobStatusChangeEvent;
import org.apache.airavata.model.messaging.event.Message;
import org.apache.airavata.model.messaging.event.MessageType;
import org.apache.airavata.model.messaging.event.TaskStatusChangeEvent;
import org.apache.airavata.model.messaging.event.WorkflowIdentifier;
import org.apache.airavata.model.messaging.event.WorkflowNodeStatusChangeEvent;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RabbitMQPublisher
implements Publisher {
    private static Logger log = LoggerFactory.getLogger(RabbitMQPublisher.class);
    private RabbitMQProducer rabbitMQProducer;

    public RabbitMQPublisher() throws Exception {
        String exchangeName;
        String brokerUrl;
        try {
            brokerUrl = ServerSettings.getSetting((String)"rabbitmq.broker.url");
            exchangeName = ServerSettings.getSetting((String)"rabbitmq.exchange.name");
        }
        catch (ApplicationSettingsException e) {
            String message = "Failed to get read the required properties from airavata to initialize rabbitmq";
            log.error(message, (Throwable)e);
            throw new AiravataException(message, (Throwable)e);
        }
        this.rabbitMQProducer = new RabbitMQProducer(brokerUrl, exchangeName);
        this.rabbitMQProducer.open();
    }

    @Override
    public void publish(MessageContext msgCtx) throws AiravataException {
        try {
            ExperimentStatusChangeEvent event;
            log.info("Publishing status to rabbitmq...");
            byte[] body = ThriftUtils.serializeThriftObject((TBase)msgCtx.getEvent());
            Message message = new Message();
            message.setEvent(body);
            message.setMessageId(msgCtx.getMessageId());
            message.setMessageType(msgCtx.getType());
            message.setUpdatedTime(msgCtx.getUpdatedTime().getTime());
            String routingKey = null;
            if (msgCtx.getType().equals((Object)MessageType.EXPERIMENT)) {
                event = (ExperimentStatusChangeEvent)msgCtx.getEvent();
                routingKey = event.getExperimentId();
            } else if (msgCtx.getType().equals((Object)MessageType.TASK)) {
                event = (TaskStatusChangeEvent)msgCtx.getEvent();
                routingKey = event.getTaskIdentity().getExperimentId() + "." + event.getTaskIdentity().getWorkflowNodeId() + "." + event.getTaskIdentity().getTaskId();
            } else if (msgCtx.getType().equals((Object)MessageType.WORKFLOWNODE)) {
                event = (WorkflowNodeStatusChangeEvent)msgCtx.getEvent();
                WorkflowIdentifier workflowNodeIdentity = event.getWorkflowNodeIdentity();
                routingKey = workflowNodeIdentity.getExperimentId() + "." + workflowNodeIdentity.getWorkflowNodeId();
            } else if (msgCtx.getType().equals((Object)MessageType.JOB)) {
                event = (JobStatusChangeEvent)msgCtx.getEvent();
                JobIdentifier identity = event.getJobIdentity();
                routingKey = identity.getExperimentId() + "." + identity.getWorkflowNodeId() + "." + identity.getTaskId() + "." + identity.getJobId();
            }
            byte[] messageBody = ThriftUtils.serializeThriftObject((TBase)message);
            this.rabbitMQProducer.send(messageBody, routingKey);
        }
        catch (TException e) {
            String msg = "Error while deserializing the object";
            log.error(msg, (Throwable)e);
            throw new AiravataException(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Error while sending to rabbitmq";
            log.error(msg, (Throwable)e);
            throw new AiravataException(msg, (Throwable)e);
        }
    }
}

