/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.messaging.core;

import org.apache.airavata.common.exception.AiravataException;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.messaging.core.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherFactory {
    private static Logger log = LoggerFactory.getLogger(PublisherFactory.class);

    public static Publisher createPublisher() throws AiravataException {
        String activityPublisher = ServerSettings.getActivityPublisher();
        if (activityPublisher == null) {
            String s = "Activity publisher is not specified";
            log.error(s);
            throw new AiravataException(s);
        }
        try {
            Class<Publisher> aPublisher = Class.forName(activityPublisher).asSubclass(Publisher.class);
            return aPublisher.newInstance();
        }
        catch (Exception e) {
            String msg = "Failed to load the publisher from the publisher class property: " + activityPublisher;
            log.error(msg, (Throwable)e);
            throw new AiravataException(msg, (Throwable)e);
        }
    }
}

