/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.session;

import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueSession;
import jakarta.jms.ServerSessionPool;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicSession;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.objectweb.jtests.jms.framework.UnifiedTestCase;

public class UnifiedSessionTest
extends UnifiedTestCase {
    protected QueueConnection queueConnection;
    protected QueueSession queueSession;
    protected TopicConnection topicConnection;
    protected TopicSession topicSession;

    public void testCreateDurableConnectionConsumerOnQueueConnection() {
        try {
            this.queueConnection.createDurableConnectionConsumer(this.topic, "subscriptionName", "", (ServerSessionPool)null, 1);
            Assert.fail((String)"Should throw a jakarta.jms.IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.IllegalStateException, not a " + e));
        }
    }

    public void testCreateDurableSubscriberOnQueueSession() {
        try {
            this.queueSession.createDurableSubscriber(this.topic, "subscriptionName");
            Assert.fail((String)"Should throw a jakarta.jms.IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.IllegalStateException, not a " + e));
        }
    }

    public void testCreateTemporaryTopicOnQueueSession() {
        try {
            this.queueSession.createTemporaryTopic();
            Assert.fail((String)"Should throw a jakarta.jms.IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.IllegalStateException, not a " + e));
        }
    }

    public void testCreateTopicOnQueueSession() {
        try {
            this.queueSession.createTopic("topic_name");
            Assert.fail((String)"Should throw a jakarta.jms.IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.IllegalStateException, not a " + e));
        }
    }

    public void testUnsubscribeOnQueueSession() {
        try {
            this.queueSession.unsubscribe("subscriptionName");
            Assert.fail((String)"Should throw a jakarta.jms.IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.IllegalStateException, not a " + e));
        }
    }

    public void testCreateBrowserOnTopicSession() {
        try {
            this.topicSession.createBrowser(this.queue);
            Assert.fail((String)"Should throw a jakarta.jms.IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.IllegalStateException, not a " + e));
        }
    }

    public void testCreateQueueOnTopicSession() {
        try {
            this.topicSession.createQueue("queue_name");
            Assert.fail((String)"Should throw a jakarta.jms.IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.IllegalStateException, not a " + e));
        }
    }

    public void testCreateTemporaryQueueOnTopicSession() {
        try {
            this.topicSession.createTemporaryQueue();
            Assert.fail((String)"Should throw a jakarta.jms.IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (JMSException e) {
            Assert.fail((String)("Should throw a jakarta.jms.IllegalStateException, not a " + e));
        }
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        try {
            this.queueConnection = this.queueConnectionFactory.createQueueConnection();
            this.queueSession = this.queueConnection.createQueueSession(false, 1);
            this.topicConnection = this.topicConnectionFactory.createTopicConnection();
            this.topicSession = this.topicConnection.createTopicSession(false, 1);
            this.queueConnection.start();
            this.topicConnection.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.queueConnection.close();
            this.topicConnection.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.queueConnection = null;
            this.queueSession = null;
            this.topicConnection = null;
            this.topicSession = null;
            super.tearDown();
        }
    }

    public static Test suite() {
        return new TestSuite(UnifiedSessionTest.class);
    }

    public UnifiedSessionTest(String name) {
        super(name);
    }
}

