/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jtests.jms.conform.message.properties;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.junit.Assert;
import org.objectweb.jtests.jms.framework.PTPTestCase;

public class MessagePropertyConversionTest
extends PTPTestCase {
    public void testString2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            Assert.assertEquals((Object)"3.14159", (Object)message.getStringProperty("pi"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Double_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "not_a_number");
            message.getDoubleProperty("pi");
            Assert.fail((String)"sec. 3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Double_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            Assert.assertEquals((double)3.14159, (double)message.getDoubleProperty("pi"), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Float_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "not_a_number");
            message.getFloatProperty("pi");
            Assert.fail((String)"sec. 3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Float_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            Assert.assertEquals((float)3.14159f, (float)message.getFloatProperty("pi"), (float)0.0f);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Long_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            message.getLongProperty("pi");
            Assert.fail((String)"sec. 3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Long_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "0");
            Assert.assertEquals((long)0L, (long)message.getLongProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Int_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            message.getIntProperty("pi");
            Assert.fail((String)"sec. 3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Int_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "0");
            Assert.assertEquals((long)0L, (long)message.getIntProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Short_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            message.getShortProperty("pi");
            Assert.fail((String)"sec. 3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Short_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "0");
            Assert.assertEquals((long)0L, (long)message.getShortProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Byte_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("pi", "3.14159");
            message.getByteProperty("pi");
            Assert.fail((String)"sec. 3.5.4 The String to numeric conversions must throw the java.lang.NumberFormatException  if the numeric's valueOf() method does not accept the String value as a valid representation.\n");
        }
        catch (NumberFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Byte_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "0");
            Assert.assertEquals((long)0L, (long)message.getByteProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Boolean_2() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "test");
            Assert.assertEquals((Object)false, (Object)message.getBooleanProperty("prop"));
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testString2Boolean_1() {
        try {
            Message message = this.senderSession.createMessage();
            message.setStringProperty("prop", "true");
            Assert.assertEquals((Object)true, (Object)message.getBooleanProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            Assert.assertEquals((Object)"127.0", (Object)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            Assert.assertEquals((double)127.0, (double)message.getDoubleProperty("prop"), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getFloatProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getLongProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getIntProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getShortProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getByteProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testDouble2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setDoubleProperty("prop", 127.0);
            message.getBooleanProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            Assert.assertEquals((Object)"127.0", (Object)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            Assert.assertEquals((double)127.0, (double)message.getDoubleProperty("prop"), (double)0.0);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            Assert.assertEquals((float)127.0f, (float)message.getFloatProperty("prop"), (float)0.0f);
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            message.getLongProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            message.getIntProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            message.getShortProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            message.getByteProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testFloat2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setFloatProperty("prop", 127.0f);
            message.getBooleanProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            Assert.assertEquals((Object)"127", (Object)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getDoubleProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getFloatProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            Assert.assertEquals((long)127L, (long)message.getLongProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getIntProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getShortProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getByteProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testLong2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setLongProperty("prop", 127L);
            message.getBooleanProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", 127);
            Assert.assertEquals((Object)"127", (Object)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", 127);
            message.getDoubleProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", 127);
            message.getFloatProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", 127);
            Assert.assertEquals((long)127L, (long)message.getLongProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", 127);
            Assert.assertEquals((long)127L, (long)message.getIntProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", Integer.MAX_VALUE);
            message.getShortProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", Integer.MAX_VALUE);
            message.getByteProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testInt2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setIntProperty("prop", Integer.MAX_VALUE);
            message.getBooleanProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            Assert.assertEquals((Object)"127", (Object)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            message.getDoubleProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            message.getFloatProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            Assert.assertEquals((long)127L, (long)message.getLongProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            Assert.assertEquals((long)127L, (long)message.getIntProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            Assert.assertEquals((long)127L, (long)message.getShortProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            message.getByteProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testShort2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setShortProperty("prop", (short)127);
            message.getBooleanProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            Assert.assertEquals((Object)"127", (Object)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            message.getDoubleProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            message.getFloatProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            Assert.assertEquals((long)127L, (long)message.getLongProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            Assert.assertEquals((long)127L, (long)message.getIntProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            Assert.assertEquals((long)127L, (long)message.getShortProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            Assert.assertEquals((long)127L, (long)message.getByteProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testByte2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setByteProperty("prop", (byte)127);
            message.getBooleanProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2String() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            Assert.assertEquals((Object)"true", (Object)message.getStringProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Double() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            message.getDoubleProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Float() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            message.getFloatProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Long() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("true", true);
            message.getLongProperty("true");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Int() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            message.getIntProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Short() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            message.getShortProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Byte() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            message.getByteProperty("prop");
            Assert.fail((String)"sec. 3.5.4 The unmarked cases [of Table 0-4] should raise a JMS MessageFormatException.\n");
        }
        catch (MessageFormatException message) {
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public void testBoolean2Boolean() {
        try {
            Message message = this.senderSession.createMessage();
            message.setBooleanProperty("prop", true);
            Assert.assertEquals((Object)true, (Object)message.getBooleanProperty("prop"));
        }
        catch (JMSException e) {
            this.fail((Exception)((Object)e));
        }
    }

    public static Test suite() {
        return new TestSuite(MessagePropertyConversionTest.class);
    }

    public MessagePropertyConversionTest(String name) {
        super(name);
    }
}

