/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class StompEmbeddedWithInterceptorExample {
    private static final String END_OF_FRAME = "\u0000";

    public static void main(String[] args) throws Exception {
        try (Socket socket = new Socket("localhost", 61616);){
            String connectFrame = "CONNECT\naccept-version:1.2\nhost:localhost\nlogin:guest\npasscode:guest\nrequest-id:1\n\n\u0000";
            StompEmbeddedWithInterceptorExample.sendFrame(socket, connectFrame);
            String text = "Hello World from Stomp 1.2 !";
            String message = "SEND\ndestination:exampleQueue\n" + text + END_OF_FRAME;
            StompEmbeddedWithInterceptorExample.sendFrame(socket, message);
            System.out.println("Sent Stomp message: " + text);
            String disconnectFrame = "DISCONNECT\n\n\u0000";
            StompEmbeddedWithInterceptorExample.sendFrame(socket, disconnectFrame);
        }
        var2_2 = null;
        try (ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory();
             Connection connection = factory.createConnection();
             Session session = connection.createSession();){
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue("exampleQueue"));
            Message messageReceived = consumer.receive(5000L);
            String propStomp = messageReceived.getStringProperty("stompIntercepted");
            String propRegular = messageReceived.getStringProperty("regularIntercepted");
            System.out.println("propStomp is Hello!! - " + propStomp.equals("Hello"));
            System.out.println("propRegular is HelloAgain!! - " + propRegular.equals("HelloAgain"));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    private static void sendFrame(Socket socket, String data) throws Exception {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        OutputStream outputStream = socket.getOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            outputStream.write(bytes[i]);
        }
        outputStream.flush();
    }
}

