/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnectionFactory;

public class VirtualTopicMappingExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block5: {
            try (Connection connection = null;){
                ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
                connection = cf.createConnection();
                Session session = connection.createSession(false, 1);
                Queue queue = session.createQueue("Consumer.A.VirtualTopic.Orders");
                MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
                connection.start();
                Topic topic = session.createTopic("VirtualTopic.Orders");
                MessageProducer producer = session.createProducer((Destination)topic);
                TextMessage message = session.createTextMessage("This is a text message");
                producer.send((Message)message);
                System.out.println("Sent message with ID: " + message.getJMSMessageID() + " to Topic: " + topic.getTopicName());
                TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
                if (messageReceived != null) {
                    System.out.println("Received message with ID: " + messageReceived.getJMSMessageID() + " from Queue: " + queue.getQueueName());
                    break block5;
                }
                throw new RuntimeException("EXAMPLE FAILED - No message received from Queue: " + queue.getQueueName());
            }
        }
    }
}

