/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.util.ServerUtil;

public class QueueExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        Process server0;
        block5: {
            Connection connection = null;
            server0 = null;
            try {
                server0 = ServerUtil.startServer((String)args[0], (String)(QueueExample.class.getSimpleName() + "0"), (int)0, (int)5000);
                ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
                connection = cf.createConnection();
                Session session = connection.createSession(false, 1);
                Queue queue = session.createQueue("exampleQueue");
                MessageProducer producer = session.createProducer((Destination)queue);
                int nMessages = 1000;
                for (int i = 0; i < nMessages; ++i) {
                    TextMessage message = session.createTextMessage("This is a text message " + i);
                    System.out.println("Sent message: " + message.getText());
                    producer.send((Message)message);
                }
                connection.close();
                ServerUtil.killServer((Process)server0);
                server0 = ServerUtil.startServer((String)args[0], (String)(QueueExample.class.getSimpleName() + "0"), (int)0, (int)5000);
                ServerUtil.waitForServerToStart((int)0, (int)5000);
                connection = cf.createConnection();
                session = connection.createSession(false, 1);
                CountDownLatch latch = new CountDownLatch(nMessages);
                MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
                messageConsumer.setMessageListener((MessageListener)new LocalListener(latch));
                connection.start();
                if (!latch.await(5L, TimeUnit.SECONDS)) {
                    throw new RuntimeException("listener didn't receive all the messages");
                }
                System.out.println("Finished ok!");
                if (connection == null) break block5;
            }
            catch (Throwable throwable) {
                if (connection != null) {
                    connection.close();
                }
                ServerUtil.killServer(server0);
                throw throwable;
            }
            connection.close();
        }
        ServerUtil.killServer((Process)server0);
    }

    private static class LocalListener
    implements MessageListener {
        CountDownLatch latch;

        LocalListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onMessage(Message message) {
            this.latch.countDown();
            try {
                System.out.println("Received " + ((TextMessage)message).getText());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

