/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.mqtt.example;

import java.util.concurrent.TimeUnit;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.Message;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;

public class MQTTBasicPubSubExample {
    public static void main(String[] args) throws Exception {
        System.out.println("Connecting to Artemis using MQTT");
        MQTT mqtt = new MQTT();
        mqtt.setHost("tcp://localhost:1883");
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        System.out.println("Connected to Artemis");
        Topic[] topics = new Topic[]{new Topic("mqtt/example/publish", QoS.AT_LEAST_ONCE), new Topic("mqtt/#", QoS.EXACTLY_ONCE)};
        connection.subscribe(topics);
        System.out.println("Subscribed to topics.");
        String payload1 = "This is message 1";
        String payload2 = "This is message 2";
        connection.publish("mqtt/example/publish", payload1.getBytes(), QoS.AT_LEAST_ONCE, false);
        connection.publish("mqtt/test", payload2.getBytes(), QoS.AT_MOST_ONCE, false);
        System.out.println("Sent messages.");
        Message message1 = connection.receive(5L, TimeUnit.SECONDS);
        Message message2 = connection.receive(5L, TimeUnit.SECONDS);
        System.out.println("Received messages.");
        System.out.println(new String(message1.getPayload()));
        System.out.println(new String(message2.getPayload()));
    }
}

