/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.common.example.ActiveMQExample;

public class TransactionalExample
extends ActiveMQExample {
    public static void main(String[] args) {
        new TransactionalExample().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runExample() throws Exception {
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createConnection();
            connection.start();
            Session session = connection.createSession(true, 0);
            MessageProducer messageProducer = session.createProducer((Destination)queue);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            TextMessage message1 = session.createTextMessage("This is a text message1");
            TextMessage message2 = session.createTextMessage("This is a text message2");
            messageProducer.send((Message)message1);
            messageProducer.send((Message)message2);
            System.out.println("Sent message: " + message1.getText());
            System.out.println("Sent message: " + message2.getText());
            TextMessage receivedMessage = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Message received before send commit: " + receivedMessage);
            session.commit();
            receivedMessage = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Message received after send commit: " + receivedMessage.getText());
            session.rollback();
            receivedMessage = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Message1 received after receive rollback: " + receivedMessage.getText());
            receivedMessage = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Message2 received after receive rollback: " + receivedMessage.getText());
            receivedMessage = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Message3 received after receive rollback: " + receivedMessage);
            session.commit();
            receivedMessage = (TextMessage)messageConsumer.receive(5000L);
            if (receivedMessage != null) {
                boolean bl = false;
                return bl;
            }
            System.out.println("Message received after receive commit: " + receivedMessage);
            boolean bl = true;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (initialContext != null) {
                initialContext.close();
            }
        }
    }
}

