/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.TransactionRolledBackException;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.common.example.ActiveMQExample;

public class TransactionFailoverExample
extends ActiveMQExample {
    String uniqueID = Long.toString(System.currentTimeMillis());

    public static void main(String[] args) {
        new TransactionFailoverExample().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runExample() throws Exception {
        int numMessages = 10;
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = connectionFactory.createConnection();
            Session session = connection.createSession(true, 0);
            connection.start();
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            this.sendMessages(session, producer, 10, true);
            try {
                session.commit();
            }
            catch (TransactionRolledBackException e) {
                System.err.println("transaction has been rolled back: " + e.getMessage());
            }
            this.sendMessages(session, producer, 10, false);
            session.commit();
            for (int i = 0; i < 10; ++i) {
                TextMessage message0 = (TextMessage)consumer.receive(5000L);
                if (message0 == null) {
                    System.err.println("Example failed - message wasn't received");
                    boolean bl = false;
                    return bl;
                }
                System.out.println("Got message: " + message0.getText());
            }
            session.commit();
            System.out.println("Other message on the server? " + consumer.receive(5000L));
            boolean bl = true;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (initialContext != null) {
                initialContext.close();
            }
        }
    }

    private void sendMessages(Session session, MessageProducer producer, int numMessages, boolean killServer) throws Exception {
        TextMessage message;
        int i;
        for (i = 0; i < numMessages / 2; ++i) {
            message = session.createTextMessage("This is text message " + i);
            message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID.toString(), this.uniqueID + i);
            producer.send((Message)message);
            System.out.println("Sent message: " + message.getText());
        }
        if (killServer) {
            Thread.sleep(5000L);
            this.killServer(0);
        }
        for (i = numMessages / 2; i < numMessages; ++i) {
            message = session.createTextMessage("This is text message " + i);
            message.setStringProperty(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID.toString(), this.uniqueID + i);
            producer.send((Message)message);
            System.out.println("Sent message: " + message.getText());
        }
    }
}

