/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.common.example.ActiveMQExample;

public class StaticSelectorJMSExample
extends ActiveMQExample {
    private volatile boolean result = true;

    public static void main(String[] args) {
        new StaticSelectorJMSExample().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runExample() throws Exception {
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Session producerSession = connection.createSession(false, 1);
            MessageProducer producer = producerSession.createProducer((Destination)queue);
            MessageConsumer redConsumer = session.createConsumer((Destination)queue);
            redConsumer.setMessageListener((MessageListener)new SimpleMessageListener("red"));
            TextMessage redMessage1 = session.createTextMessage("Red-1");
            redMessage1.setStringProperty("color", "red");
            TextMessage redMessage2 = session.createTextMessage("Red-2");
            redMessage2.setStringProperty("color", "red");
            TextMessage greenMessage = session.createTextMessage("Green");
            greenMessage.setStringProperty("color", "green");
            TextMessage blueMessage = session.createTextMessage("Blue");
            blueMessage.setStringProperty("color", "blue");
            TextMessage normalMessage = session.createTextMessage("No color");
            producer.send((Message)redMessage1);
            System.out.println("Message sent: " + redMessage1.getText());
            producer.send((Message)greenMessage);
            System.out.println("Message sent: " + greenMessage.getText());
            producer.send((Message)blueMessage);
            System.out.println("Message sent: " + blueMessage.getText());
            producer.send((Message)redMessage2);
            System.out.println("Message sent: " + redMessage2.getText());
            producer.send((Message)normalMessage);
            System.out.println("Message sent: " + normalMessage.getText());
            Thread.sleep(5000L);
            boolean bl = this.result;
            return bl;
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    public class SimpleMessageListener
    implements MessageListener {
        private final String name;

        public SimpleMessageListener(String listener) {
            this.name = listener;
        }

        public void onMessage(Message msg) {
            TextMessage textMessage = (TextMessage)msg;
            try {
                String colorProp = msg.getStringProperty("color");
                System.out.println("Receiver " + this.name + " receives message [" + textMessage.getText() + "] with color property: " + colorProp);
                if (colorProp != null && !colorProp.equals(this.name)) {
                    StaticSelectorJMSExample.this.result = false;
                }
            }
            catch (JMSException e) {
                e.printStackTrace();
                StaticSelectorJMSExample.this.result = false;
            }
        }
    }
}

