/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;

public class MessageSender {
    private ConnectionFactory connectionFactory;
    private Destination destination;

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String msg) {
        Connection conn = null;
        try {
            conn = this.connectionFactory.createConnection();
            Session session = conn.createSession(false, 1);
            MessageProducer producer = session.createProducer(this.destination);
            TextMessage message = session.createTextMessage(msg);
            producer.send((Message)message);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

