/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.common.example.ActiveMQExample;

public class ReplicatedFailbackExample
extends ActiveMQExample {
    public static void main(String[] args) {
        new ReplicatedFailbackExample().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runExample() throws Exception {
        int numMessages = 30;
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            int i;
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = connectionFactory.createConnection();
            Session session = connection.createSession(false, 2);
            connection.start();
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i2 = 0; i2 < 30; ++i2) {
                TextMessage message = session.createTextMessage("This is text message " + i2);
                producer.send((Message)message);
                System.out.println("Sent message: " + message.getText());
            }
            TextMessage message0 = null;
            for (i = 0; i < 10; ++i) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText());
            }
            message0.acknowledge();
            for (i = 10; i < 30; ++i) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText());
            }
            Thread.sleep(5000L);
            this.killServer(0);
            try {
                message0.acknowledge();
            }
            catch (JMSException e) {
                System.out.println("Got (the expected) exception while acknowledging message: " + e.getMessage());
            }
            for (int i3 = 10; i3 < 20; ++i3) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.printf("Got message: %s (redelivered?: %s)\n", message0.getText(), message0.getJMSRedelivered());
            }
            message0.acknowledge();
            this.reStartServer(0, 10000L);
            Thread.sleep(10000L);
            try {
                message0.acknowledge();
            }
            catch (JMSException e) {
                System.err.println("Got exception while acknowledging message: " + e.getMessage());
            }
            for (int i4 = 20; i4 < 30; ++i4) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.printf("Got message: %s (redelivered?: %s)\n", message0.getText(), message0.getJMSRedelivered());
            }
            message0.acknowledge();
            boolean bl = true;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (initialContext != null) {
                initialContext.close();
            }
        }
    }
}

