/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueRequestor;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.management.JMSManagementHelper;
import org.apache.activemq.artemis.common.example.ActiveMQExample;

public class PreacknowledgeExample
extends ActiveMQExample {
    public static void main(String[] args) {
        new PreacknowledgeExample().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runExample() throws Exception {
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createConnection();
            Session session = connection.createSession(false, 100);
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            TextMessage message1 = session.createTextMessage("This is a text message 1");
            producer.send((Message)message1);
            System.out.println("Sent message: " + message1.getText());
            int count = this.getMessageCount(connection);
            System.out.println("Queue message count is " + count);
            connection.start();
            Thread.sleep(1000L);
            count = this.getMessageCount(connection);
            System.out.println("Queue message count is now " + count);
            if (count != 0) {
                boolean bl = false;
                return bl;
            }
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Received message: " + messageReceived.getText());
            boolean bl = true;
            return bl;
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private int getMessageCount(Connection connection) throws Exception {
        QueueSession session = ((QueueConnection)connection).createQueueSession(false, 1);
        Queue managementQueue = ActiveMQJMSClient.createQueue((String)"activemq.management");
        QueueRequestor requestor = new QueueRequestor(session, managementQueue);
        connection.start();
        Message m = session.createMessage();
        JMSManagementHelper.putAttribute((Message)m, (String)"jms.queue.exampleQueue", (String)"messageCount");
        Message response = requestor.request(m);
        int messageCount = (Integer)JMSManagementHelper.getResult((Message)response);
        return messageCount;
    }
}

