/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueRequestor;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.management.JMSManagementHelper;
import org.apache.activemq.artemis.common.example.ActiveMQExample;

public class ManagementExample
extends ActiveMQExample {
    public static void main(String[] args) {
        new ManagementExample().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runExample() throws Exception {
        QueueConnection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            QueueConnectionFactory cf = (QueueConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createQueueConnection();
            QueueSession session = connection.createQueueSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            System.out.println("Sent message: " + message.getText());
            producer.send((Message)message);
            Queue managementQueue = ActiveMQJMSClient.createQueue((String)"activemq.management");
            QueueRequestor requestor = new QueueRequestor(session, managementQueue);
            connection.start();
            Message m = session.createMessage();
            JMSManagementHelper.putAttribute((Message)m, (String)"jms.queue.exampleQueue", (String)"messageCount");
            Message reply = requestor.request(m);
            int messageCount = (Integer)JMSManagementHelper.getResult((Message)reply);
            System.out.println(queue.getQueueName() + " contains " + messageCount + " messages");
            m = session.createMessage();
            JMSManagementHelper.putOperationInvocation((Message)m, (String)"jms.queue.exampleQueue", (String)"removeMessage", (Object[])new Object[]{message.getJMSMessageID()});
            reply = requestor.request(m);
            boolean success = JMSManagementHelper.hasOperationSucceeded((Message)reply);
            System.out.println("operation invocation has succeeded: " + success);
            boolean messageRemoved = (Boolean)JMSManagementHelper.getResult((Message)reply);
            System.out.println("message has been removed: " + messageRemoved);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Received message: " + messageReceived);
            boolean bl = true;
            return bl;
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }
}

