/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.api.jms.management.JMSQueueControl;
import org.apache.activemq.artemis.common.example.ActiveMQExample;

public class JMXExample
extends ActiveMQExample {
    private static final String JMX_URL = "service:jmx:rmi:///jndi/rmi://localhost:3000/jmxrmi";

    public static void main(String[] args) {
        new JMXExample().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runExample() throws Exception {
        QueueConnection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            QueueConnectionFactory cf = (QueueConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createQueueConnection();
            QueueSession session = connection.createQueueSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            System.out.println("Sent message: " + message.getText());
            producer.send((Message)message);
            ObjectName on = ObjectNameBuilder.DEFAULT.getJMSQueueObjectName(queue.getQueueName());
            JMXConnector connector = JMXConnectorFactory.connect(new JMXServiceURL(JMX_URL), new HashMap());
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            JMSQueueControl queueControl = MBeanServerInvocationHandler.newProxyInstance(mbsc, on, JMSQueueControl.class, false);
            System.out.println(queueControl.getName() + " contains " + queueControl.getMessageCount() + " messages");
            System.out.println("message has been removed: " + queueControl.removeMessage(message.getJMSMessageID()));
            System.out.println(queueControl.getName() + " contains " + queueControl.getMessageCount() + " messages");
            connector.close();
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            connection.start();
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Received message: " + messageReceived);
            boolean bl = true;
            return bl;
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }
}

