/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.Hashtable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.common.example.ActiveMQExample;

public class ClusteredGroupingExample
extends ActiveMQExample {
    public static void main(String[] args) {
        new ClusteredGroupingExample().run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runExample() throws Exception {
        Connection connection0 = null;
        Connection connection1 = null;
        Connection connection2 = null;
        InitialContext ic0 = null;
        InitialContext ic1 = null;
        InitialContext ic2 = null;
        try {
            TextMessage message;
            int i;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
            properties.put("connectionFactory.ConnectionFactory", this.args[0]);
            properties.put("queue.queue/exampleQueue", "exampleQueue");
            ic0 = new InitialContext(properties);
            Queue queue = (Queue)ic0.lookup("queue/exampleQueue");
            ConnectionFactory cf0 = (ConnectionFactory)ic0.lookup("ConnectionFactory");
            properties = new Hashtable();
            properties.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
            properties.put("connectionFactory.ConnectionFactory", this.args[1]);
            ic1 = new InitialContext(properties);
            ConnectionFactory cf1 = (ConnectionFactory)ic1.lookup("ConnectionFactory");
            properties = new Hashtable();
            properties.put("java.naming.factory.initial", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory");
            properties.put("connectionFactory.ConnectionFactory", this.args[2]);
            ic2 = new InitialContext(properties);
            ConnectionFactory cf2 = (ConnectionFactory)ic2.lookup("ConnectionFactory");
            connection0 = cf0.createConnection();
            connection1 = cf1.createConnection();
            connection2 = cf2.createConnection();
            Session session0 = connection0.createSession(false, 1);
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection1.createSession(false, 1);
            connection0.start();
            connection1.start();
            connection2.start();
            MessageConsumer consumer = session0.createConsumer((Destination)queue);
            MessageProducer producer0 = session0.createProducer((Destination)queue);
            MessageProducer producer1 = session1.createProducer((Destination)queue);
            MessageProducer producer2 = session2.createProducer((Destination)queue);
            int numMessages = 10;
            for (i = 0; i < 10; ++i) {
                message = session0.createTextMessage("This is text message " + i);
                message.setStringProperty("JMSXGroupID", "Group-0");
                producer0.send((Message)message);
                System.out.println("Sent messages: " + message.getText() + " to node 0");
            }
            for (i = 0; i < 10; ++i) {
                message = session1.createTextMessage("This is text message " + (i + 10));
                message.setStringProperty("JMSXGroupID", "Group-0");
                producer1.send((Message)message);
                System.out.println("Sent messages: " + message.getText() + " to node 1");
            }
            for (i = 0; i < 10; ++i) {
                message = session2.createTextMessage("This is text message " + (i + 20));
                message.setStringProperty("JMSXGroupID", "Group-0");
                producer2.send((Message)message);
                System.out.println("Sent messages: " + message.getText() + " to node 2");
            }
            for (i = 0; i < 30; ++i) {
                TextMessage message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText() + " from node 0");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (connection0 != null) {
                connection0.close();
            }
            if (connection1 != null) {
                connection1.close();
            }
            if (connection2 != null) {
                connection2.close();
            }
            if (ic0 != null) {
                ic0.close();
            }
            if (ic1 != null) {
                ic1.close();
            }
            if (ic2 != null) {
                ic2.close();
            }
        }
    }
}

