/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class FederatedQueueExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connectionEUWest = null;
        Connection connectionEUEast = null;
        Connection connectionUSCentral = null;
        try {
            TextMessage messageEUEast;
            TextMessage messageUSCentral;
            TextMessage messageEUWest;
            TextMessage message;
            int i;
            Queue queue = ActiveMQJMSClient.createQueue((String)"exampleQueue");
            ActiveMQConnectionFactory cfEUWest = new ActiveMQConnectionFactory("tcp://localhost:61616");
            ActiveMQConnectionFactory cfEUEast = new ActiveMQConnectionFactory("tcp://localhost:61617");
            ActiveMQConnectionFactory cfUSCentral = new ActiveMQConnectionFactory("tcp://localhost:61618");
            connectionEUWest = cfEUWest.createConnection();
            connectionEUEast = cfEUEast.createConnection();
            connectionUSCentral = cfUSCentral.createConnection();
            Session sessionEUWest = connectionEUWest.createSession(false, 1);
            Session sessionEUEast = connectionEUEast.createSession(false, 1);
            Session sessionUSCentral = connectionUSCentral.createSession(false, 1);
            connectionEUWest.start();
            connectionEUEast.start();
            connectionUSCentral.start();
            MessageProducer producerEUWest = sessionEUWest.createProducer((Destination)queue);
            MessageProducer producerEUEast = sessionEUEast.createProducer((Destination)queue);
            MessageProducer producerUSCentral = sessionUSCentral.createProducer((Destination)queue);
            MessageConsumer consumerEUWest = sessionEUWest.createConsumer((Destination)queue);
            MessageConsumer consumerEUEast = sessionEUEast.createConsumer((Destination)queue);
            MessageConsumer consumerUSCentral = sessionUSCentral.createConsumer((Destination)queue);
            Thread.sleep(5000L);
            int numMessages = 10;
            for (i = 0; i < 10; ++i) {
                message = sessionEUWest.createTextMessage("This is text sent from EU West, message " + i);
                producerEUWest.send((Message)message);
                System.out.println("EU West   :: Sent message: " + message.getText());
            }
            for (i = 0; i < 10; ++i) {
                messageEUWest = (TextMessage)consumerEUWest.receive(5000L);
                System.out.println("EU West   :: Got message: " + messageEUWest.getText());
            }
            for (i = 0; i < 10; ++i) {
                message = sessionEUWest.createTextMessage("This is text sent from US Central, message " + i);
                producerUSCentral.send((Message)message);
                System.out.println("US Central:: Sent message: " + message.getText());
            }
            for (i = 0; i < 10; ++i) {
                messageUSCentral = (TextMessage)consumerUSCentral.receive(5000L);
                System.out.println("US Central:: Got message: " + messageUSCentral.getText());
            }
            consumerEUWest.close();
            System.out.println("Consumer EU West now closed");
            for (i = 0; i < 10; ++i) {
                message = sessionEUWest.createTextMessage("This is text sent from EU West, message " + i);
                producerEUWest.send((Message)message);
                System.out.println("EU West   :: Sent message: " + message.getText());
            }
            for (i = 0; i < 10; ++i) {
                messageEUEast = (TextMessage)consumerEUEast.receive(5000L);
                System.out.println("EU East   :: Got message: " + messageEUEast.getText());
            }
            consumerUSCentral.close();
            System.out.println("Consumer US Central now closed");
            for (i = 0; i < 10; ++i) {
                message = sessionUSCentral.createTextMessage("This is text sent from US Central, message " + i);
                producerUSCentral.send((Message)message);
                System.out.println("US Central:: Sent message: " + message.getText());
            }
            for (i = 0; i < 10; ++i) {
                messageEUEast = (TextMessage)consumerEUEast.receive(5000L);
                System.out.println("EU East   :: Got message: " + messageEUEast.getText());
            }
            consumerEUWest = sessionEUWest.createConsumer((Destination)queue);
            System.out.println("Consumer EU West re-created");
            consumerUSCentral = sessionUSCentral.createConsumer((Destination)queue);
            System.out.println("Consumer US Central re-created");
            for (i = 0; i < 10; ++i) {
                message = sessionUSCentral.createTextMessage("This is text sent from US Central, message " + i);
                producerUSCentral.send((Message)message);
                System.out.println("US Central:: Sent message: " + message.getText());
            }
            for (i = 0; i < 10; ++i) {
                messageUSCentral = (TextMessage)consumerUSCentral.receive(5000L);
                System.out.println("US Central:: Got message: " + messageUSCentral.getText());
            }
            for (i = 0; i < 10; ++i) {
                message = sessionEUWest.createTextMessage("This is text sent from EU West, message " + i);
                producerEUWest.send((Message)message);
                System.out.println("EU West   :: Sent message: " + message.getText());
            }
            for (i = 0; i < 10; ++i) {
                messageEUWest = (TextMessage)consumerEUWest.receive(5000L);
                System.out.println("EU West   :: Got message: " + messageEUWest.getText());
            }
        }
        finally {
            if (connectionEUWest != null) {
                connectionEUWest.stop();
                connectionEUWest.close();
            }
            if (connectionEUEast != null) {
                connectionEUEast.stop();
                connectionEUEast.close();
            }
            if (connectionUSCentral != null) {
                connectionUSCentral.stop();
                connectionUSCentral.close();
            }
        }
    }
}

