/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.util.ServerUtil;

public class ZookeeperSinglePairFailback {
    private static Process server0;
    private static Process server1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int numMessages = 30;
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            int i;
            int i2;
            server0 = ServerUtil.startServer((String)args[0], (String)(ZookeeperSinglePairFailback.class.getSimpleName() + "-primary"), (int)0, (int)30000);
            server1 = ServerUtil.startServer((String)args[1], (String)(ZookeeperSinglePairFailback.class.getSimpleName() + "-backup"), (int)1, (int)10000);
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = connectionFactory.createConnection();
            Session session = connection.createSession(false, 2);
            connection.start();
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i3 = 0; i3 < 30; ++i3) {
                TextMessage message = session.createTextMessage("This is text message " + i3);
                producer.send((Message)message);
                System.out.println("Sent message: " + message.getText());
            }
            TextMessage message0 = null;
            for (i2 = 0; i2 < 10; ++i2) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText());
            }
            message0.acknowledge();
            System.out.println("Received and acknowledged a third of the sent messages");
            for (i2 = 10; i2 < 30; ++i2) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText());
            }
            System.out.println("Received without acknowledged the rest of the sent messages");
            Thread.sleep(2000L);
            ServerUtil.killServer((Process)server0);
            System.out.println("Killed primary");
            Thread.sleep(2000L);
            try {
                message0.acknowledge();
            }
            catch (JMSException e) {
                System.out.println("Got (the expected) exception while acknowledging message: " + e.getMessage());
            }
            for (i = 10; i < 20; ++i) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.printf("Got message: %s (redelivered?: %s)\n", message0.getText(), message0.getJMSRedelivered());
            }
            message0.acknowledge();
            System.out.println("Acknowledged 2n third of messages");
            server0 = ServerUtil.startServer((String)args[0], (String)(ZookeeperSinglePairFailback.class.getSimpleName() + "-primary"), (int)0, (int)10000);
            System.out.println("Started primary");
            Thread.sleep(4000L);
            for (i = 20; i < 30; ++i) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.printf("Got message: %s (redelivered?: %s)\n", message0.getText(), message0.getJMSRedelivered());
            }
            message0.acknowledge();
            System.out.println("Acknowledged 3d third of messages");
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (initialContext != null) {
                initialContext.close();
            }
            ServerUtil.killServer((Process)server0);
            ServerUtil.killServer((Process)server1);
        }
    }
}

