/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.util.ServerUtil;

public class MultipleFailoverExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int numMessages = 30;
        Connection connection = null;
        InitialContext initialContext = null;
        Process[] servers = new Process[3];
        try {
            int i;
            int i2;
            for (int i3 = 0; i3 < args.length; ++i3) {
                servers[i3] = ServerUtil.startServer((String)args[i3], (String)(MultipleFailoverExample.class.getSimpleName() + i3), (int)i3, (int)5000);
            }
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = connectionFactory.createConnection();
            Session session = connection.createSession(false, 2);
            connection.start();
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i4 = 0; i4 < 30; ++i4) {
                TextMessage message = session.createTextMessage("This is text message " + i4);
                producer.send((Message)message);
                System.out.println("Sent message: " + message.getText());
            }
            TextMessage message0 = null;
            for (i2 = 0; i2 < 10; ++i2) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText());
            }
            message0.acknowledge();
            for (i2 = 10; i2 < 30; ++i2) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText());
            }
            ServerUtil.killServer((Process)servers[0]);
            try {
                message0.acknowledge();
            }
            catch (JMSException e) {
                System.err.println("Got exception while acknowledging message: " + e.getMessage());
            }
            for (i = 10; i < 20; ++i) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.printf("Got message: %s (redelivered?: %s)%n", message0.getText(), message0.getJMSRedelivered());
            }
            message0.acknowledge();
            ServerUtil.killServer((Process)servers[ServerUtil.getServer((Connection)connection)]);
            try {
                message0.acknowledge();
            }
            catch (JMSException e) {
                throw new IllegalStateException("Got exception while acknowledging message: " + e.getMessage());
            }
            for (i = 20; i < 30; ++i) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.printf("Got message: %s (redelivered?: %s)%n", message0.getText(), message0.getJMSRedelivered());
            }
            message0.acknowledge();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (initialContext != null) {
                initialContext.close();
            }
            for (int i = 0; i < args.length; ++i) {
                ServerUtil.killServer((Process)servers[i]);
            }
        }
    }
}

