/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.util.ServerUtil;

public class MultipleFailoverFailbackExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int numMessages = 30;
        Connection connection = null;
        InitialContext initialContext = null;
        Process[] servers = new Process[3];
        try {
            int i;
            for (int i2 = 0; i2 < args.length; ++i2) {
                servers[i2] = ServerUtil.startServer((String)args[i2], (String)(MultipleFailoverFailbackExample.class.getSimpleName() + i2), (int)i2, (int)5000);
            }
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = connectionFactory.createConnection();
            Session session = connection.createSession(false, 2);
            connection.start();
            MessageProducer producer = session.createProducer((Destination)queue);
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i3 = 0; i3 < 30; ++i3) {
                TextMessage message = session.createTextMessage("This is text message " + i3);
                producer.send((Message)message);
                System.out.println("Sent message: " + message.getText());
            }
            TextMessage message0 = null;
            for (i = 0; i < 10; ++i) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText());
            }
            message0.acknowledge();
            for (i = 10; i < 30; ++i) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText());
            }
            ServerUtil.killServer((Process)servers[0]);
            try {
                message0.acknowledge();
            }
            catch (JMSException e) {
                System.err.println("Got exception while acknowledging message: " + e.getMessage());
            }
            for (int i4 = 10; i4 < 20; ++i4) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.printf("Got message: %s (redelivered?: %s)%n", message0.getText(), message0.getJMSRedelivered());
            }
            message0.acknowledge();
            servers[0] = ServerUtil.startServer((String)args[0], (String)(MultipleFailoverFailbackExample.class.getSimpleName() + 0), (int)0, (int)5000);
            try {
                message0.acknowledge();
            }
            catch (JMSException e) {
                System.err.println("Got exception while acknowledging message: " + e.getMessage());
            }
            for (int i5 = 20; i5 < 30; ++i5) {
                message0 = (TextMessage)consumer.receive(5000L);
                System.out.printf("Got message: %s (redelivered?: %s)%n", message0.getText(), message0.getJMSRedelivered());
            }
            message0.acknowledge();
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (initialContext != null) {
                initialContext.close();
            }
            for (int i = 0; i < args.length; ++i) {
                ServerUtil.killServer((Process)servers[i]);
            }
        }
    }
}

