/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.util.ServerUtil;

public class ApplicationLayerFailoverExample {
    private static InitialContext initialContext;
    private static Connection connection;
    private static Session session;
    private static MessageConsumer consumer;
    private static MessageProducer producer;
    private static final CountDownLatch failoverLatch;
    private static Process server0;
    private static Process server1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            int i;
            int i2;
            server0 = ServerUtil.startServer((String)args[0], (String)(ApplicationLayerFailoverExample.class.getSimpleName() + "0"), (int)0, (int)5000);
            server1 = ServerUtil.startServer((String)args[1], (String)(ApplicationLayerFailoverExample.class.getSimpleName() + "1"), (int)1, (int)5000);
            ApplicationLayerFailoverExample.createJMSObjects(0);
            connection.setExceptionListener((ExceptionListener)new ExampleListener());
            System.out.println("The initial JMS objects have been created, and the ExceptionListener set");
            int numMessages = 10;
            for (i2 = 0; i2 < 10; ++i2) {
                TextMessage message = session.createTextMessage("This is text message " + i2);
                producer.send((Message)message);
                System.out.println("Sent message: " + message.getText());
            }
            for (i2 = 0; i2 < 10; ++i2) {
                TextMessage message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText());
            }
            System.out.println("Killing the server");
            ServerUtil.killServer((Process)server0);
            boolean ok = failoverLatch.await(5000L, TimeUnit.MILLISECONDS);
            System.out.println("Reconnection has occurred. Now sending more messages.");
            for (i = 10; i < 20; ++i) {
                TextMessage message = session.createTextMessage("This is text message " + i);
                producer.send((Message)message);
                System.out.println("Sent message: " + message.getText());
            }
            for (i = 0; i < 10; ++i) {
                TextMessage message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            ApplicationLayerFailoverExample.closeResources();
            ServerUtil.killServer((Process)server0);
            ServerUtil.killServer((Process)server1);
        }
    }

    private static void createJMSObjects(int server) throws Exception {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("tcp://127.0.0.1:" + (61616 + server));
        connection = connectionFactory.createConnection();
        connection.start();
        session = connection.createSession(false, 1);
        Queue queue = session.createQueue("exampleQueue");
        consumer = session.createConsumer((Destination)queue);
        producer = session.createProducer((Destination)queue);
    }

    private static void closeResources() {
        if (initialContext != null) {
            try {
                initialContext.close();
            }
            catch (NamingException e) {
                e.printStackTrace();
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        failoverLatch = new CountDownLatch(1);
    }

    private static class ExampleListener
    implements ExceptionListener {
        private ExampleListener() {
        }

        public void onException(JMSException exception) {
            try {
                connection.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            for (int i = 0; i < 10; ++i) {
                try {
                    System.out.println("Connection failure has been detected on a the client.");
                    System.out.println("The old resources have been closed.");
                    ApplicationLayerFailoverExample.createJMSObjects(1);
                    System.out.println("The new resources have been created.");
                    failoverLatch.countDown();
                    return;
                }
                catch (Exception e) {
                    System.out.println("Failed to handle failover, trying again.");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            System.out.println("tried 10 times to reconnect, giving up");
        }
    }
}

