/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class SymmetricClusterExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection0 = null;
        Connection connection1 = null;
        Connection connection2 = null;
        Connection connection3 = null;
        Connection connection4 = null;
        Connection connection5 = null;
        try {
            int i;
            UDPBroadcastEndpointFactory udpCfg = new UDPBroadcastEndpointFactory();
            udpCfg.setGroupAddress("231.7.7.7").setGroupPort(9876);
            DiscoveryGroupConfiguration groupConfiguration = new DiscoveryGroupConfiguration();
            groupConfiguration.setBroadcastEndpointFactory((BroadcastEndpointFactory)udpCfg);
            ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithHA((DiscoveryGroupConfiguration)groupConfiguration, (JMSFactoryType)JMSFactoryType.CF);
            Thread.sleep(2000L);
            Queue queue = ActiveMQJMSClient.createQueue((String)"exampleQueue");
            Topic topic = ActiveMQJMSClient.createTopic((String)"exampleTopic");
            connection0 = cf.createConnection();
            connection1 = cf.createConnection();
            connection2 = cf.createConnection();
            connection3 = cf.createConnection();
            connection4 = cf.createConnection();
            connection5 = cf.createConnection();
            connection0.start();
            connection1.start();
            connection2.start();
            connection3.start();
            connection4.start();
            connection5.start();
            Session session0 = connection0.createSession(false, 1);
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            Session session3 = connection0.createSession(false, 1);
            Session session4 = connection1.createSession(false, 1);
            Session session5 = connection2.createSession(false, 1);
            MessageConsumer subscriber0 = session0.createConsumer((Destination)topic);
            MessageConsumer subscriber1 = session1.createConsumer((Destination)topic);
            MessageConsumer subscriber2 = session2.createConsumer((Destination)topic);
            MessageConsumer subscriber3 = session3.createConsumer((Destination)topic);
            MessageConsumer subscriber4 = session4.createConsumer((Destination)topic);
            MessageConsumer subscriber5 = session5.createConsumer((Destination)topic);
            MessageConsumer consumer0 = session0.createConsumer((Destination)queue);
            MessageProducer producer2 = session2.createProducer(null);
            int numMessages = 500;
            for (i = 0; i < 500; ++i) {
                TextMessage message1 = session2.createTextMessage("Topic message " + i);
                producer2.send((Destination)topic, (Message)message1);
                TextMessage message2 = session2.createTextMessage("Queue message " + i);
                producer2.send((Destination)queue, (Message)message2);
            }
            for (i = 0; i < 500; ++i) {
                TextMessage received0 = (TextMessage)subscriber0.receive(5000L);
                if (received0 == null) {
                    throw new IllegalStateException("Message is null!");
                }
                TextMessage received1 = (TextMessage)subscriber1.receive(5000L);
                if (received1 == null) {
                    throw new IllegalStateException("Message is null!");
                }
                TextMessage received2 = (TextMessage)subscriber2.receive(5000L);
                if (received2 == null) {
                    throw new IllegalStateException("Message is null!");
                }
                TextMessage received3 = (TextMessage)subscriber3.receive(5000L);
                if (received3 == null) {
                    throw new IllegalStateException("Message is null!");
                }
                TextMessage received4 = (TextMessage)subscriber4.receive(5000L);
                if (received4 == null) {
                    throw new IllegalStateException("Message is null!");
                }
                TextMessage received5 = (TextMessage)subscriber5.receive(5000L);
                if (received5 == null) {
                    throw new IllegalStateException("Message is null!");
                }
                TextMessage received6 = (TextMessage)consumer0.receive(5000L);
                if (received6 != null) continue;
                throw new IllegalStateException("Message is null!");
            }
        }
        finally {
            connection0.close();
            connection1.close();
            connection2.close();
            connection3.close();
            connection4.close();
            connection5.close();
        }
    }
}

