/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class ClusteredTopicExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection0 = null;
        Connection connection1 = null;
        InitialContext ic0 = null;
        InitialContext ic1 = null;
        try {
            int i;
            Topic topic = ActiveMQJMSClient.createTopic((String)"exampleTopic");
            ActiveMQConnectionFactory cf0 = new ActiveMQConnectionFactory("tcp://localhost:61616");
            ActiveMQConnectionFactory cf1 = new ActiveMQConnectionFactory("tcp://localhost:61617");
            connection0 = cf0.createConnection();
            connection1 = cf1.createConnection();
            Session session0 = connection0.createSession(false, 1);
            Session session1 = connection1.createSession(false, 1);
            connection0.start();
            connection1.start();
            MessageConsumer consumer0 = session0.createConsumer((Destination)topic);
            MessageConsumer consumer1 = session1.createConsumer((Destination)topic);
            Thread.sleep(1000L);
            MessageProducer producer = session0.createProducer((Destination)topic);
            int numMessages = 10;
            for (i = 0; i < 10; ++i) {
                TextMessage message = session0.createTextMessage("This is text message " + i);
                producer.send((Message)message);
                System.out.println("Sent message: " + message.getText());
            }
            for (i = 0; i < 10; ++i) {
                TextMessage message0 = (TextMessage)consumer0.receive(5000L);
                System.out.println("Got message: " + message0.getText() + " from node 0");
                TextMessage message1 = (TextMessage)consumer1.receive(5000L);
                System.out.println("Got message: " + message1.getText() + " from node 1");
            }
        }
        finally {
            if (connection0 != null) {
                connection0.close();
            }
            if (connection1 != null) {
                connection1.close();
            }
            if (ic0 != null) {
                ic0.close();
            }
            if (ic1 != null) {
                ic1.close();
            }
        }
    }
}

