/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.util.ServerUtil;

public class ClusterStaticOnewayExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection initialConnection = null;
        Connection connection0 = null;
        Connection connection1 = null;
        Connection connection2 = null;
        try {
            int i;
            Queue queue = ActiveMQJMSClient.createQueue((String)"exampleQueue");
            ActiveMQConnectionFactory cf0 = new ActiveMQConnectionFactory("tcp://localhost:61616");
            initialConnection = cf0.createConnection();
            Thread.sleep(2000L);
            connection0 = cf0.createConnection();
            connection1 = cf0.createConnection();
            connection2 = cf0.createConnection();
            Session session0 = connection0.createSession(false, 1);
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection2.createSession(false, 1);
            connection0.start();
            connection1.start();
            connection2.start();
            MessageConsumer consumer0 = session0.createConsumer((Destination)queue);
            MessageConsumer consumer1 = session1.createConsumer((Destination)queue);
            MessageConsumer consumer2 = session2.createConsumer((Destination)queue);
            Thread.sleep(4000L);
            int con0Node = ServerUtil.getServer((Connection)connection0);
            int con1Node = ServerUtil.getServer((Connection)connection1);
            int con2Node = ServerUtil.getServer((Connection)connection2);
            System.out.println("con0Node = " + con0Node);
            System.out.println("con1Node = " + con1Node);
            System.out.println("con2Node = " + con2Node);
            if (con0Node + con1Node + con2Node != 3) {
                throw new IllegalStateException("connections not load balanced");
            }
            Session sendSession = ServerUtil.getServerConnection((int)0, (Connection[])new Connection[]{connection0, connection1, connection2}).createSession(false, 1);
            MessageProducer producer = sendSession.createProducer((Destination)queue);
            int numMessages = 18;
            for (i = 0; i < 18; ++i) {
                TextMessage message = session0.createTextMessage("This is text message " + i);
                producer.send((Message)message);
                System.out.println("Sent message: " + message.getText());
            }
            Thread.sleep(2000L);
            for (i = 0; i < 18; i += 3) {
                TextMessage message0 = (TextMessage)consumer0.receive(5000L);
                System.out.println("Got message: " + message0.getText() + " from node " + con0Node);
                TextMessage message1 = (TextMessage)consumer1.receive(5000L);
                System.out.println("Got message: " + message1.getText() + " from node " + con1Node);
                TextMessage message2 = (TextMessage)consumer2.receive(5000L);
                System.out.println("Got message: " + message2.getText() + " from node " + con2Node);
            }
        }
        finally {
            if (initialConnection != null) {
                initialConnection.close();
            }
            if (connection0 != null) {
                connection0.close();
            }
            if (connection1 != null) {
                connection1.close();
            }
            if (connection2 != null) {
                connection2.close();
            }
        }
    }
}

