/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class ClusteredGroupingExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection0 = null;
        Connection connection1 = null;
        Connection connection2 = null;
        try {
            TextMessage message;
            int i;
            Queue queue = ActiveMQJMSClient.createQueue((String)"exampleQueue");
            ActiveMQConnectionFactory cf0 = new ActiveMQConnectionFactory("tcp://localhost:61616");
            ActiveMQConnectionFactory cf1 = new ActiveMQConnectionFactory("tcp://localhost:61617");
            ActiveMQConnectionFactory cf2 = new ActiveMQConnectionFactory("tcp://localhost:61618");
            connection0 = cf0.createConnection();
            connection1 = cf1.createConnection();
            connection2 = cf2.createConnection();
            Session session0 = connection0.createSession(false, 1);
            Session session1 = connection1.createSession(false, 1);
            Session session2 = connection1.createSession(false, 1);
            connection0.start();
            connection1.start();
            connection2.start();
            MessageConsumer consumer = session0.createConsumer((Destination)queue);
            MessageProducer producer0 = session0.createProducer((Destination)queue);
            MessageProducer producer1 = session1.createProducer((Destination)queue);
            MessageProducer producer2 = session2.createProducer((Destination)queue);
            int numMessages = 10;
            for (i = 0; i < 10; ++i) {
                message = session0.createTextMessage("This is text message " + i);
                message.setStringProperty("JMSXGroupID", "Group-0");
                producer0.send((Message)message);
                System.out.println("Sent messages: " + message.getText() + " to node 0");
            }
            for (i = 0; i < 10; ++i) {
                message = session1.createTextMessage("This is text message " + (i + 10));
                message.setStringProperty("JMSXGroupID", "Group-0");
                producer1.send((Message)message);
                System.out.println("Sent messages: " + message.getText() + " to node 1");
            }
            for (i = 0; i < 10; ++i) {
                message = session2.createTextMessage("This is text message " + (i + 20));
                message.setStringProperty("JMSXGroupID", "Group-0");
                producer2.send((Message)message);
                System.out.println("Sent messages: " + message.getText() + " to node 2");
            }
            for (i = 0; i < 30; ++i) {
                TextMessage message0 = (TextMessage)consumer.receive(5000L);
                System.out.println("Got message: " + message0.getText() + " from node 0");
            }
        }
        finally {
            if (connection0 != null) {
                connection0.close();
            }
            if (connection1 != null) {
                connection1.close();
            }
            if (connection2 != null) {
                connection2.close();
            }
        }
    }
}

