/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class ClusteredDurableSubscriptionExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection0 = null;
        Connection connection1 = null;
        try {
            int i;
            ActiveMQConnectionFactory cf0 = new ActiveMQConnectionFactory("tcp://localhost:61616");
            ActiveMQConnectionFactory cf1 = new ActiveMQConnectionFactory("tcp://localhost:61617");
            connection0 = cf0.createConnection();
            String clientID = "my-client-id";
            connection0.setClientID("my-client-id");
            connection1 = cf1.createConnection();
            connection1.setClientID("my-client-id");
            Session session0 = connection0.createSession(false, 1);
            Session session1 = connection1.createSession(false, 1);
            connection0.start();
            connection1.start();
            String subscriptionName = "my-subscription";
            Topic topic = session0.createTopic("exampleTopic");
            TopicSubscriber subscriber0 = session0.createDurableSubscriber(topic, "my-subscription");
            TopicSubscriber subscriber1 = session1.createDurableSubscriber(topic, "my-subscription");
            Thread.sleep(1000L);
            MessageProducer producer = session0.createProducer((Destination)topic);
            int numMessages = 10;
            for (i = 0; i < 10; ++i) {
                TextMessage message = session0.createTextMessage("This is text message " + i);
                producer.send((Message)message);
                System.out.println("Sent message: " + message.getText());
            }
            for (i = 0; i < 10; i += 2) {
                TextMessage message0 = (TextMessage)subscriber0.receive(5000L);
                System.out.println("Got message: " + message0.getText() + " from node 0");
                TextMessage message1 = (TextMessage)subscriber1.receive(5000L);
                System.out.println("Got message: " + message1.getText() + " from node 1");
            }
        }
        finally {
            if (connection0 != null) {
                connection0.close();
            }
            if (connection1 != null) {
                connection1.close();
            }
            Thread.sleep(1000L);
        }
    }
}

