/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.jms.client.ActiveMQSession;

public class ClientSideLoadBalancingExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InitialContext initialContext = null;
        Connection connectionA = null;
        Connection connectionB = null;
        Connection connectionC = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            try (Connection conn = connectionFactory.createConnection();){
                Thread.sleep(5000L);
                connectionA = connectionFactory.createConnection();
                connectionB = connectionFactory.createConnection();
                connectionC = connectionFactory.createConnection();
            }
            Session sessionA = connectionA.createSession(false, 1);
            Session sessionB = connectionB.createSession(false, 1);
            Session sessionC = connectionC.createSession(false, 1);
            System.out.println("Session A - " + ((ClientSessionInternal)((ActiveMQSession)sessionA).getCoreSession()).getConnection().getRemoteAddress());
            System.out.println("Session B - " + ((ClientSessionInternal)((ActiveMQSession)sessionB).getCoreSession()).getConnection().getRemoteAddress());
            System.out.println("Session C - " + ((ClientSessionInternal)((ActiveMQSession)sessionC).getCoreSession()).getConnection().getRemoteAddress());
            MessageProducer producerA = sessionA.createProducer((Destination)queue);
            MessageProducer producerB = sessionB.createProducer((Destination)queue);
            MessageProducer producerC = sessionC.createProducer((Destination)queue);
            int numMessages = 10;
            for (int i = 0; i < 10; ++i) {
                TextMessage messageA = sessionA.createTextMessage("A:This is text message " + i);
                producerA.send((Message)messageA);
                System.out.println("Sent message: " + messageA.getText());
                TextMessage messageB = sessionB.createTextMessage("B:This is text message " + i);
                producerB.send((Message)messageB);
                System.out.println("Sent message: " + messageB.getText());
                TextMessage messageC = sessionC.createTextMessage("C:This is text message " + i);
                producerC.send((Message)messageC);
                System.out.println("Sent message: " + messageC.getText());
            }
            connectionA.start();
            connectionB.start();
            connectionC.start();
            ClientSideLoadBalancingExample.consume(sessionA, queue, 10, "A");
            ClientSideLoadBalancingExample.consume(sessionB, queue, 10, "B");
            ClientSideLoadBalancingExample.consume(sessionC, queue, 10, "C");
        }
        finally {
            if (connectionA != null) {
                connectionA.close();
            }
            if (connectionB != null) {
                connectionB.close();
            }
            if (connectionC != null) {
                connectionC.close();
            }
            if (initialContext != null) {
                initialContext.close();
            }
        }
    }

    private static void consume(Session session, Queue queue, int numMessages, String node) throws JMSException {
        MessageConsumer consumer = session.createConsumer((Destination)queue);
        for (int i = 0; i < numMessages; ++i) {
            TextMessage message = (TextMessage)consumer.receive(2000L);
            System.out.println("Got message: " + message.getText() + " from node " + node);
        }
        System.out.println("receive other message from node " + node + ": " + consumer.receive(2000L));
    }
}

