/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;

public class TopicSelectorExample1 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            TextMessage messageReceivedC;
            TextMessage messageReceivedB;
            TextMessage messageReceivedA;
            initialContext = new InitialContext();
            Topic topic = (Topic)initialContext.lookup("topic/exampleTopic");
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)topic);
            MessageConsumer messageConsumer1 = session.createConsumer((Destination)topic, "someID=1", false);
            MessageConsumer messageConsumer2 = session.createConsumer((Destination)topic, "someID=2", false);
            MessageConsumer messageConsumer3 = session.createConsumer((Destination)topic);
            for (int i = 1; i < 10; ++i) {
                for (int someID = 1; someID <= 2; ++someID) {
                    TextMessage message1 = session.createTextMessage("This is a text message " + i + " sent for someID=" + someID);
                    message1.setIntProperty("someID", someID);
                    producer.send((Message)message1);
                    System.out.println("Sent message: " + message1.getText());
                }
            }
            connection.start();
            System.out.println("*************************************************************");
            System.out.println("MessageConsumer1 will only receive messages where someID=1:");
            while ((messageReceivedA = (TextMessage)messageConsumer1.receive(1000L)) != null) {
                System.out.println("messageConsumer1 received " + messageReceivedA.getText() + " someID = " + messageReceivedA.getIntProperty("someID"));
            }
            System.out.println("*************************************************************");
            System.out.println("MessageConsumer2 will only receive messages where someID=2:");
            while ((messageReceivedB = (TextMessage)messageConsumer2.receive(1000L)) != null) {
                System.out.println("messageConsumer2 received " + messageReceivedB.getText() + " someID = " + messageReceivedB.getIntProperty("someID"));
            }
            System.out.println("*************************************************************");
            System.out.println("MessageConsumer3 will receive every message:");
            while ((messageReceivedC = (TextMessage)messageConsumer3.receive(1000L)) != null) {
                System.out.println("messageConsumer3 received " + messageReceivedC.getText() + " someID = " + messageReceivedC.getIntProperty("someID"));
            }
            messageConsumer1.close();
            messageConsumer2.close();
            messageConsumer3.close();
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }
}

