/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

public class TemporaryQueueExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            TemporaryQueue tempQueue = session.createTemporaryQueue();
            System.out.println("Temporary queue is created: " + tempQueue);
            MessageProducer messageProducer = session.createProducer((Destination)tempQueue);
            TextMessage message = session.createTextMessage("This is a text message");
            messageProducer.send((Message)message);
            System.out.println("Sent message: " + message.getText());
            MessageConsumer messageConsumer = session.createConsumer((Destination)tempQueue);
            message = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Received message: " + message.getText());
            messageConsumer.close();
            messageProducer.close();
            tempQueue.delete();
            TemporaryQueue tempQueue2 = session.createTemporaryQueue();
            System.out.println("Another temporary queue is created: " + tempQueue2);
            connection.close();
            connection = cf.createConnection();
            session = connection.createSession(false, 1);
            try {
                messageConsumer = session.createConsumer((Destination)tempQueue2);
                throw new Exception("Temporary queue cannot be accessed outside its lifecycle!");
            }
            catch (JMSException e) {
                System.out.println("Exception got when trying to access a temp queue outside its scope: " + (Object)((Object)e));
                if (connection != null) {
                    connection.close();
                }
                if (initialContext != null) {
                    initialContext.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (connection != null) {
                connection.close();
            }
            if (initialContext != null) {
                initialContext.close();
            }
            throw throwable;
        }
    }
}

