/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.jms.example.SimpleMessageListener;

public class StaticSelectorExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        AtomicInteger good = new AtomicInteger(0);
        AtomicInteger bad = new AtomicInteger(0);
        AtomicBoolean failed = new AtomicBoolean(false);
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createConnection();
            connection.start();
            Session session = connection.createSession(false, 1);
            Session producerSession = connection.createSession(false, 1);
            MessageProducer producer = producerSession.createProducer((Destination)queue);
            MessageConsumer redConsumer = session.createConsumer((Destination)queue);
            redConsumer.setMessageListener((MessageListener)new SimpleMessageListener("red", failed, good, bad));
            TextMessage redMessage1 = session.createTextMessage("Red-1");
            redMessage1.setStringProperty("color", "red");
            TextMessage redMessage2 = session.createTextMessage("Red-2");
            redMessage2.setStringProperty("color", "red");
            TextMessage greenMessage = session.createTextMessage("Green");
            greenMessage.setStringProperty("color", "green");
            TextMessage blueMessage = session.createTextMessage("Blue");
            blueMessage.setStringProperty("color", "blue");
            TextMessage normalMessage = session.createTextMessage("No color");
            producer.send((Message)redMessage1);
            System.out.println("Message sent: " + redMessage1.getText());
            producer.send((Message)greenMessage);
            System.out.println("Message sent: " + greenMessage.getText());
            producer.send((Message)blueMessage);
            System.out.println("Message sent: " + blueMessage.getText());
            producer.send((Message)redMessage2);
            System.out.println("Message sent: " + redMessage2.getText());
            producer.send((Message)normalMessage);
            System.out.println("Message sent: " + normalMessage.getText());
            Thread.sleep(5000L);
            if (good.get() != 2 || bad.get() != 0 || failed.get()) {
                throw new IllegalStateException();
            }
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }
}

