/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

class SimpleMessageListener
implements MessageListener {
    private final String name;
    private AtomicInteger good;
    private AtomicInteger bad;
    private AtomicBoolean failed;

    SimpleMessageListener(String listener, AtomicBoolean failed, AtomicInteger good, AtomicInteger bad) {
        this.name = listener;
        this.failed = failed;
        this.good = good;
        this.bad = bad;
    }

    public void onMessage(Message msg) {
        TextMessage textMessage = (TextMessage)msg;
        try {
            String colorProp = msg.getStringProperty("color");
            System.out.println("Receiver " + this.name + " receives message [" + textMessage.getText() + "] with color property: " + colorProp);
            if (colorProp != null && colorProp.equals(this.name)) {
                this.good.incrementAndGet();
            } else {
                this.bad.incrementAndGet();
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.failed.set(true);
        }
    }
}

