/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;

class SimpleMessageListener
implements MessageListener {
    private final String name;
    private AtomicBoolean result;

    SimpleMessageListener(String listener, AtomicBoolean result) {
        this.name = listener;
        this.result = result;
    }

    public void onMessage(Message msg) {
        TextMessage textMessage = (TextMessage)msg;
        try {
            String colorProp = msg.getStringProperty("color");
            System.out.println("Receiver " + this.name + " receives message [" + textMessage.getText() + "] with color property: " + colorProp);
            if (colorProp != null && !colorProp.equals(this.name)) {
                this.result.set(false);
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
            this.result.set(false);
        }
    }
}

