/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

public class SSLDualAuthenticationExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection producerConnection = null;
        Connection consumerConnection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory producerConnectionFactory = (ConnectionFactory)initialContext.lookup("SslConnectionFactory");
            ConnectionFactory consumerConnectionFactory = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            producerConnection = producerConnectionFactory.createConnection();
            consumerConnection = consumerConnectionFactory.createConnection("consumer", "activemq");
            Session producerSession = producerConnection.createSession(false, 1);
            Session consumerSession = consumerConnection.createSession(false, 1);
            MessageProducer producer = producerSession.createProducer((Destination)queue);
            TextMessage message = producerSession.createTextMessage("This is a text message");
            System.out.println("Sent message: " + message.getText());
            producer.send((Message)message);
            MessageConsumer messageConsumer = consumerSession.createConsumer((Destination)queue);
            consumerConnection.start();
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Received message: " + messageReceived.getText());
            initialContext.close();
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (producerConnection != null) {
                producerConnection.close();
            }
            if (consumerConnection != null) {
                consumerConnection.close();
            }
        }
    }
}

