/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;

public class NotifySlowConsumerExample {
    public static final int WAIT_TIME = 10;

    public static void main(String[] args) throws Exception {
        InitialContext initialContext = new InitialContext();
        Queue slowConsumerNotifyQueue = (Queue)initialContext.lookup("queue/slow.consumer.notify");
        Topic notificationTopic = (Topic)initialContext.lookup("topic/notify.topic");
        ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)slowConsumerNotifyQueue);
            CountDownLatch waitForSlowConsumerNotif = new CountDownLatch(1);
            connection.start();
            Session notifSession = connection.createSession(false, 1);
            MessageConsumer notificationConsumer = notifSession.createConsumer((Destination)notificationTopic, ManagementHelper.HDR_NOTIFICATION_TYPE + " = '" + CoreNotificationType.CONSUMER_SLOW + "'");
            notificationConsumer.setMessageListener(message -> {
                System.out.println("SUCCESS! Received CONSUMER_SLOW notification as expected: " + message);
                waitForSlowConsumerNotif.countDown();
            });
            TextMessage message2 = session.createTextMessage("This is a text message");
            System.out.println("Sending messages to queue ... ");
            for (int i = 0; i < 50; ++i) {
                producer.send((Message)message2);
            }
            MessageConsumer messageConsumer = session.createConsumer((Destination)slowConsumerNotifyQueue);
            System.out.println("About to wait for CONSUMER_SLOW notification, will timeout after 10 seconds ...");
            boolean isNotified = waitForSlowConsumerNotif.await(10L, TimeUnit.SECONDS);
            if (!isNotified) {
                throw new RuntimeException("SlowConsumerExample.demoSlowConsumerNotify() FAILED; timeout occurred before - slow consumer notification was received. ");
            }
        }
    }
}

