/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import java.util.concurrent.TimeUnit;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;

public class KillSlowConsumerExample {
    public static final int WAIT_TIME = 10;

    public static void main(String[] args) throws Exception {
        InitialContext initialContext = new InitialContext();
        Queue slowConsumerKillQueue = (Queue)initialContext.lookup("queue/slow.consumer.kill");
        ConnectionFactory connectionFactory = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
        Connection connection = connectionFactory.createConnection();
        Throwable throwable = null;
        try {
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)slowConsumerKillQueue);
            TextMessage message = session.createTextMessage("This is a text message");
            System.out.println("Sending messages to queue ... ");
            for (int i = 0; i < 50; ++i) {
                producer.send((Message)message);
            }
            MessageConsumer messageConsumer = session.createConsumer((Destination)slowConsumerKillQueue);
            connection.start();
            System.out.println("About to wait for 10 seconds");
            Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
            try {
                messageConsumer.receive(TimeUnit.SECONDS.toMillis(1L));
                throw new RuntimeException("SlowConsumerExample.slowConsumerKill() FAILED - expected connection to be shutdown by Slow Consumer policy");
            }
            catch (JMSException ex) {
                if (!(ex.getCause() instanceof ActiveMQObjectClosedException)) {
                    throw new RuntimeException("SlowConsumerExample.slowConsumerKill() FAILED - expected ActiveMQObjectClosedException BUT got " + ex.getCause());
                }
                System.out.println("SUCCESS! Received EXPECTED exception: " + (Object)((Object)ex));
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        connection.close();
                    }
                }
            }
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (connection != null) {
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        connection.close();
                    }
                }
                throw throwable4;
            }
        }
    }
}

