/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.management.JMSManagementHelper;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class ReattachExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Connection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            ConnectionFactory cf = (ConnectionFactory)initialContext.lookup("ConnectionFactory");
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            System.out.println("Sent message: " + message.getText());
            producer.send((Message)message);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            connection.start();
            ReattachExample.stopAcceptor();
            System.out.println("Acceptor now stopped, will wait for 10 seconds. This simulates the network connection failing for a while");
            Thread.sleep(10000L);
            System.out.println("Re-starting acceptor");
            ReattachExample.startAcceptor();
            System.out.println("Restarted acceptor. The client will now reconnect.");
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Received message: " + messageReceived.getText());
        }
        finally {
            if (initialContext != null) {
                initialContext.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static void stopAcceptor() throws Exception {
        ReattachExample.stopStartAcceptor(true);
    }

    private static void startAcceptor() throws Exception {
        ReattachExample.stopStartAcceptor(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopStartAcceptor(boolean stop) throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://localhost:61617");
        try (Connection connection = null;){
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            Queue managementQueue = ActiveMQJMSClient.createQueue((String)"activemq.management");
            MessageProducer producer = session.createProducer((Destination)managementQueue);
            connection.start();
            Message m = session.createMessage();
            String oper = stop ? "stop" : "start";
            JMSManagementHelper.putOperationInvocation((Message)m, (String)"core.acceptor.netty-acceptor", (String)oper);
            producer.send(m);
        }
    }
}

