/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;

public class TextReverserService
implements MessageListener {
    private final Session session;
    private final Connection connection;

    private static String reverse(String text) {
        return new StringBuffer(text).reverse().toString();
    }

    public TextReverserService(ConnectionFactory cf, Destination destination) throws JMSException {
        this.connection = cf.createConnection();
        this.session = this.connection.createSession(false, 1);
        MessageConsumer consumer = this.session.createConsumer(destination);
        consumer.setMessageListener((MessageListener)this);
        this.connection.start();
    }

    public void onMessage(Message request) {
        TextMessage textMessage = (TextMessage)request;
        try {
            String text = textMessage.getText();
            TextMessage reply = this.session.createTextMessage(TextReverserService.reverse(text));
            Destination replyTo = request.getJMSReplyTo();
            try (MessageProducer producer = this.session.createProducer(replyTo);){
                producer.send((Message)reply);
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
        }
    }
}

