/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueRequestor;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import org.apache.activemq.artemis.jms.example.TextReverserService;

public class QueueRequestorExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        QueueConnection connection = null;
        InitialContext initialContext = null;
        try {
            initialContext = new InitialContext();
            Queue queue = (Queue)initialContext.lookup("queue/exampleQueue");
            QueueConnectionFactory cf = (QueueConnectionFactory)initialContext.lookup("ConnectionFactory");
            TextReverserService reverserService = new TextReverserService((ConnectionFactory)cf, (Destination)queue);
            connection = cf.createQueueConnection();
            connection.start();
            QueueSession session = connection.createQueueSession(false, 1);
            QueueRequestor queueRequestor = new QueueRequestor(session, queue);
            TextMessage request = session.createTextMessage("Hello, World!");
            TextMessage reply = (TextMessage)queueRequestor.request((Message)request);
            System.out.println("Send request: " + request.getText());
            System.out.println("Received reply:" + reply.getText());
            queueRequestor.close();
            reverserService.close();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            if (initialContext != null) {
                initialContext.close();
            }
        }
    }
}

