/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.example;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;

public class QueueExample {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try (Connection connection = null;){
            ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory();
            connection = cf.createConnection();
            Session session = connection.createSession(false, 1);
            Queue queue = session.createQueue("exampleQueue");
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage message = session.createTextMessage("This is a text message");
            System.out.println("Sent message: " + message.getText());
            producer.send((Message)message);
            MessageConsumer messageConsumer = session.createConsumer((Destination)queue);
            connection.start();
            TextMessage messageReceived = (TextMessage)messageConsumer.receive(5000L);
            System.out.println("Received message: " + messageReceived.getText());
        }
    }
}

